/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import io.higgs.http.client.HttpRequestBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class DataSiftConfig {
    private static final String illConfigured = "(%s) is null, this is an ill-configured object and all API requests using it will fail";
    protected boolean compatibleSSLProtocolsFound;
    protected List<String> sslProtocols = new ArrayList<String>();
    protected String username;
    protected String apiKey;
    protected boolean sslEnabled = true;
    protected String host = "api.datasift.com";
    protected String wsHost = "websocket.datasift.com";
    protected HttpRequestBuilder http = HttpRequestBuilder.instance();
    protected String versionPrefix = "v1.1";
    protected String urlEncodingFormat = "ISO-8859-1";
    protected int port = 80;
    protected boolean manualPort;
    private boolean autoReconnect = true;
    protected int connectTimeout = 10000;

    public DataSiftConfig() {
        this.http.userAgent("DataSift/" + this.versionPrefix + " Java/" + this.getClientVersion());
        if (HttpRequestBuilder.isSupportedSSLProtocol((String)"SSLv3")) {
            this.sslProtocols.add("SSLv3");
        }
        if (HttpRequestBuilder.isSupportedSSLProtocol((String)"TLSv1")) {
            this.sslProtocols.add("TLSv1");
        }
        if (HttpRequestBuilder.isSupportedSSLProtocol((String)"TLSv1.2")) {
            this.sslProtocols.add("TLSv1.2");
        }
        this.compatibleSSLProtocolsFound = this.sslProtocols.size() > 0;
    }

    public DataSiftConfig(String username, String apiKey) {
        this();
        this.auth(username, apiKey);
    }

    public DataSiftConfig auth(String username, String apiKey) {
        if (username == null || apiKey == null || username.isEmpty() || apiKey.isEmpty()) {
            throw new IllegalArgumentException(String.format("A valid username and API key are required. Username = %s, API key = %s", username, apiKey));
        }
        this.username = username;
        this.apiKey = apiKey;
        return this;
    }

    public DataSiftConfig proxy(String host, int port) {
        this.http.proxy(host, port);
        return this;
    }

    public DataSiftConfig proxy(String host, int port, String username, String password) {
        this.http.proxy(host, port, username, password);
        return this;
    }

    public String protocol() {
        return this.sslEnabled ? "https://" : "http://";
    }

    public DataSiftConfig host(String host) {
        this.host = host;
        return this;
    }

    public String host() {
        return this.host;
    }

    public DataSiftConfig wsHost(String host) {
        this.wsHost = host;
        return this;
    }

    public String wsHost() {
        return this.wsHost;
    }

    public int port() {
        return this.manualPort ? this.port : (this.sslEnabled ? 443 : 80);
    }

    public void port(int p) {
        this.manualPort = true;
        this.port = p;
    }

    public URI baseURL() {
        StringBuilder b = new StringBuilder().append(this.protocol()).append(this.host()).append(":").append(this.port()).append("/").append(this.versionPrefix()).append("/");
        try {
            return new URI(b.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to construct a base URL for the API", e);
        }
    }

    public URI newAPIEndpointURI(String endpoint) {
        return this.baseURL().resolve(endpoint);
    }

    public URI newAPIEndpointURI(URI endpoint) {
        return this.baseURL().resolve(endpoint);
    }

    public String versionPrefix() {
        return this.versionPrefix;
    }

    public String getUsername() {
        if (this.username == null) {
            throw new IllegalStateException(String.format(illConfigured, "Username"));
        }
        return this.username;
    }

    public String getApiKey() {
        if (this.username == null) {
            throw new IllegalStateException(String.format(illConfigured, "API key"));
        }
        return this.apiKey;
    }

    public boolean isSslEnabled() {
        return this.sslEnabled;
    }

    public void setSslEnabled(boolean sslEnabled) {
        this.sslEnabled = sslEnabled;
        if (!this.manualPort) {
            this.port = this.sslEnabled ? 443 : 80;
        }
    }

    public String authAsHeader() {
        return this.username + ":" + this.apiKey;
    }

    public HttpRequestBuilder http() {
        return this.http;
    }

    public String urlEncodingFormat() {
        return this.urlEncodingFormat;
    }

    public DataSiftConfig urlEncodingFormat(String format) {
        this.urlEncodingFormat = format;
        return this;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public void setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
    }

    public String[] sslProtocols() {
        return this.compatibleSSLProtocolsFound() ? this.sslProtocols.toArray(new String[this.sslProtocols.size()]) : null;
    }

    public boolean compatibleSSLProtocolsFound() {
        return this.compatibleSSLProtocolsFound;
    }

    public int connectTimeout() {
        return this.connectTimeout;
    }

    public void connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String getClientVersion() {
        String path = "/version.prop";
        InputStream stream = this.getClass().getResourceAsStream(path);
        if (stream == null) {
            return "3.x";
        }
        Properties props = new Properties();
        try {
            props.load(stream);
            stream.close();
            return (String)props.get("version");
        }
        catch (IOException e) {
            return "3.x";
        }
    }
}

