/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.cli;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.cli.Parser;
import com.datasift.client.core.Stream;
import com.datasift.client.core.Usage;
import com.datasift.client.push.OutputType;
import com.datasift.client.push.PushSubscription;
import com.datasift.client.push.connectors.BaseConnector;
import com.datasift.client.push.connectors.PushConnector;
import com.datasift.client.pylon.PylonQuery;
import com.datasift.client.pylon.PylonQueryParameters;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.higgs.http.client.HttpRequestBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.joda.time.DateTime;

public class Interface {
    private static final ObjectMapper mapper = new ObjectMapper();

    private Interface() {
    }

    private static String getOrDefault(Map<String, String> map, String key, String defaultValue) {
        if (map.containsKey(key)) {
            return map.get(key);
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void main(String[] args) throws JsonProcessingException {
        try {
            ArrayList<Parser.CliSwitch> switches = new ArrayList<Parser.CliSwitch>();
            switches.add(new Parser.CliSwitch("a", "auth", true, "Auth is required in the form username:api_key"));
            switches.add(new Parser.CliSwitch("c", "command", true));
            Parser.CliSwitch endpoint = new Parser.CliSwitch("e", "endpoint");
            endpoint.setDefault("core");
            switches.add(endpoint);
            switches.add(new Parser.CliSwitch("p", "param"));
            switches.add(new Parser.CliSwitch("u", "url"));
            Parser.CliArguments parsedArgs = Parser.parse(args, switches);
            HashMap<String, String> auth = parsedArgs.map("a");
            if (auth == null || auth.size() == 0) {
                System.out.println("Auth must be provided in the form '-a[uth] username api_key'");
                System.exit(0);
            }
            Map.Entry authVals = auth.entrySet().iterator().next();
            DataSiftConfig config = new DataSiftConfig((String)authVals.getKey(), (String)authVals.getValue());
            String u = parsedArgs.get("u");
            if (u != null) {
                URI url = new URI(!u.startsWith("http") && !u.startsWith("https") ? "http://" + u : u);
                config.host(url.getHost());
                config.setSslEnabled(url.getScheme() != null && url.getScheme().equals("https"));
                config.port(url.getPort() > -1 ? url.getPort() : (config.isSslEnabled() ? 443 : 80));
            }
            DataSiftClient dataSift = new DataSiftClient(config);
            HashMap<String, String> hashMap = parsedArgs.map("p");
            if (hashMap == null) {
                HashMap hashMap2 = new HashMap();
            }
            switch (parsedArgs.get("e")) {
                case "core": {
                    void var9_13;
                    Interface.executeCore(dataSift, parsedArgs.get("c"), (Map<String, String>)var9_13);
                    return;
                }
                case "push": {
                    void var9_13;
                    Interface.executePush(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
                case "historics": {
                    void var9_13;
                    Interface.executeHistorics(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
                case "preview": {
                    void var9_13;
                    Interface.executePreview(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
                case "sources": {
                    void var9_13;
                    Interface.executeSources(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
                case "pylon": {
                    void var9_13;
                    Interface.executeAnalysis(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
                case "identity": {
                    void var9_13;
                    Interface.executeIdentity(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
                case "token": {
                    void var9_13;
                    Interface.executeToken(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
                case "limit": {
                    void var9_13;
                    Interface.executeLimit(dataSift, parsedArgs.get("c"), (HashMap<String, String>)var9_13);
                    return;
                }
            }
            return;
        }
        catch (Exception ex) {
            BaseDataSiftResult res = new BaseDataSiftResult();
            res.failed(ex);
            Interface.printResponse(res);
            return;
        }
        finally {
            HttpRequestBuilder.group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
    }

    private static void require(String[] args, Map<String, String> params) {
        ArrayList<String> missing = new ArrayList<String>();
        for (String arg : args) {
            if (params.containsKey(arg)) continue;
            missing.add(arg);
        }
        if (missing.size() > 0) {
            System.out.println("The following arguments are required : " + Arrays.toString(missing.toArray()));
            System.exit(0);
        }
    }

    private static void executeCore(DataSiftClient dataSift, String endpoint, Map<String, String> params) throws JsonProcessingException {
        switch (endpoint) {
            case "validate": {
                Interface.require(new String[]{"csdl"}, params);
                Interface.printResponse(dataSift.validate(params.get("csdl")).sync());
                break;
            }
            case "compile": {
                Interface.require(new String[]{"csdl"}, params);
                Interface.printResponse(dataSift.compile(params.get("csdl")).sync());
                break;
            }
            case "usage": {
                String period = params.get("period");
                if (period == null) {
                    Interface.printResponse(dataSift.usage().sync());
                    break;
                }
                Interface.printResponse(dataSift.usage(Usage.Period.fromStr(period)).sync());
                break;
            }
            case "dpu": {
                Interface.require(new String[]{"hash"}, params);
                Interface.printResponse(dataSift.dpu(Stream.fromString(params.get("hash"))).sync());
                break;
            }
            case "balance": {
                Interface.printResponse(dataSift.balance().sync());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printResponse(DataSiftResult result) throws JsonProcessingException {
        try {
            HashMap<String, Object> response = new HashMap<String, Object>();
            HashMap<String, String> headers = new HashMap<String, String>();
            if (result.getResponse() != null) {
                for (Map.Entry<String, List<String>> h : result.getResponse().headers().entrySet()) {
                    headers.put(h.getKey(), h.getValue() == null || h.getValue().size() == 0 ? null : h.getValue().get(0));
                }
                int status = result.getResponse().status();
                response.put("status", status);
            } else {
                response.put("error", "Invalid response, null");
            }
            response.put("body", result);
            response.put("headers", headers);
            System.out.println(mapper.writeValueAsString(response));
            System.exit(0);
        }
        catch (Exception ex) {
            BaseDataSiftResult res = new BaseDataSiftResult();
            res.failed(ex);
            System.out.println(mapper.writeValueAsString((Object)res));
            System.exit(0);
        }
        finally {
            HttpRequestBuilder.group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
        }
    }

    private static void executePush(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws IOException {
        Map args = (Map)mapper.readValue(params.get("output_type"), (TypeReference)new TypeReference<HashMap<String, Object>>(){});
        PushConnector connector = BaseConnector.fromMap(new OutputType<PushConnector>(params.get("output_type")), args);
        switch (endpoint) {
            case "validate": {
                Interface.printResponse(dataSift.push().validate(connector).sync());
                break;
            }
            case "create": {
                Interface.printResponse(dataSift.push().create(connector, Stream.fromString(params.get("hash")), params.get("name")).sync());
                break;
            }
            case "pause": {
                Interface.printResponse(dataSift.push().pause(params.get("id")).sync());
                break;
            }
            case "resume": {
                Interface.printResponse(dataSift.push().resume(params.get("id")).sync());
                break;
            }
            case "update": {
                Interface.printResponse(dataSift.push().update(params.get("id"), connector).sync());
                break;
            }
            case "stop": {
                Interface.printResponse(dataSift.push().stop(params.get("id")).sync());
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.push().delete(params.get("id")).sync());
                break;
            }
            case "log": {
                Interface.printResponse(dataSift.push().log(params.get("id"), Integer.parseInt(params.get("page"))).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.push().get(params.get("id")).sync());
                break;
            }
            case "pull": {
                Interface.printResponse(dataSift.push().pull(PushSubscription.fromString(params.get("id")), Integer.parseInt(params.get("size")), params.get("page")).sync());
            }
        }
    }

    private static void executeHistorics(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws JsonProcessingException {
        switch (endpoint) {
            case "prepare": {
                Interface.printResponse(dataSift.historics().prepare(params.get("hash"), DateTime.parse((String)params.get("start")), DateTime.parse((String)params.get("end")), params.get("name")).sync());
                break;
            }
            case "start": {
                Interface.printResponse(dataSift.historics().start(params.get("id")).sync());
                break;
            }
            case "stop": {
                Interface.printResponse(dataSift.historics().stop(params.get("id"), params.get("reason")).sync());
                break;
            }
            case "status": {
                Interface.printResponse(dataSift.historics().status(new DateTime(Long.parseLong(params.get("start"))), new DateTime(Long.parseLong(params.get("end"))), new String[0]).sync());
                break;
            }
            case "update": {
                Interface.printResponse(dataSift.historics().update(params.get("id"), params.get("name")).sync());
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.historics().delete(params.get("id")).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.historics().get(params.get("id")).sync());
            }
        }
    }

    private static void executeAnalysis(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws IOException {
        switch (endpoint) {
            case "analyze": {
                PylonQueryParameters map = null;
                String p = params.get("parameters");
                if (p != null && !p.isEmpty()) {
                    map = (PylonQueryParameters)mapper.readValue(p, PylonQueryParameters.class);
                }
                PylonQuery analysis = new PylonQuery(params.get("hash"), map, params.get("filter"), params.get("start") == null ? null : Integer.valueOf(Integer.parseInt(params.get("start"))), params.get("end") == null ? null : Integer.valueOf(Integer.parseInt(params.get("end"))));
                Interface.printResponse(dataSift.pylon().analyze(analysis).sync());
                break;
            }
            case "compile": {
                Interface.printResponse(dataSift.pylon().compile(params.get("csdl")).sync());
                break;
            }
            case "get": {
                String hash = params == null ? null : params.get("hash");
                Interface.printResponse(hash == null ? (BaseDataSiftResult)dataSift.pylon().get().sync() : (BaseDataSiftResult)dataSift.pylon().get(hash).sync());
                break;
            }
            case "start": {
                Interface.printResponse(dataSift.pylon().start(params.get("hash")).sync());
                break;
            }
            case "stop": {
                Interface.printResponse(dataSift.pylon().stop(params.get("hash")).sync());
                break;
            }
            case "tags": {
                Interface.printResponse(dataSift.pylon().tags(params.get("hash")).sync());
                break;
            }
            case "validate": {
                Interface.printResponse(dataSift.pylon().validate(params.get("csdl")).sync());
            }
        }
    }

    private static void executePreview(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws JsonProcessingException {
        switch (endpoint) {
            case "create": {
                Interface.printResponse(dataSift.preview().create(new DateTime(Long.parseLong(params.get("start"))), Stream.fromString(params.get("hash")), params.get("params").split(",")).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.preview().get(params.get("id")).sync());
            }
        }
    }

    private static void executeSources(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws JsonProcessingException {
        switch (endpoint) {
            case "create": {
                break;
            }
            case "update": {
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.managedSource().delete(params.get("id")).sync());
                break;
            }
            case "log": {
                Interface.printResponse(dataSift.managedSource().log(params.get("id")).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.managedSource().get(params.get("id")).sync());
                break;
            }
            case "stop": {
                Interface.printResponse(dataSift.managedSource().stop(params.get("id")).sync());
                break;
            }
            case "start": {
                Interface.printResponse(dataSift.managedSource().start(params.get("id")).sync());
            }
        }
    }

    private static void executeIdentity(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws IOException {
        switch (endpoint) {
            case "list": {
                String label = Interface.getOrDefault(params, "label", null);
                int page = Integer.parseInt(Interface.getOrDefault(params, "page", "0"));
                int perpage = Integer.parseInt(Interface.getOrDefault(params, "per_page", "0"));
                Interface.printResponse(dataSift.account().list(label, page, perpage).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.account().get(params.get("id")).sync());
                break;
            }
            case "create": {
                String createlabel = params.get("label");
                Boolean active = Interface.getOrDefault(params, "status", "inactive").equals("active");
                Boolean master = Interface.getOrDefault(params, "master", "false").equals("true");
                Interface.printResponse(dataSift.account().create(createlabel, active, master).sync());
                break;
            }
            case "update": {
                String targetid = params.get("id");
                String updatelabel = Interface.getOrDefault(params, "label", null);
                String updateactivitystring = Interface.getOrDefault(params, "status", null);
                Boolean updateactivity = null;
                if (updateactivitystring != null) {
                    if (updateactivitystring.equals("active")) {
                        updateactivity = true;
                    } else if (updateactivitystring.equals("inactive")) {
                        updateactivity = false;
                    }
                }
                String updatemasterstring = Interface.getOrDefault(params, "master", null);
                Boolean updatemaster = null;
                if (updatemasterstring != null) {
                    if (updatemasterstring.equals("true")) {
                        updatemaster = true;
                    } else if (updatemasterstring.equals("false")) {
                        updatemaster = false;
                    }
                }
                Interface.printResponse(dataSift.account().update(targetid, updatelabel, updateactivity, updatemaster).sync());
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.account().delete(params.get("id")).sync());
            }
        }
    }

    private static void executeToken(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws IOException {
        switch (endpoint) {
            case "list": {
                String identityid = Interface.getOrDefault(params, "identity_id", null);
                int page = Integer.parseInt(Interface.getOrDefault(params, "page", "0"));
                int perpage = Integer.parseInt(Interface.getOrDefault(params, "per_page", "0"));
                Interface.printResponse(dataSift.account().listTokens(identityid, page, perpage).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.account().getToken(params.get("identity_id"), params.get("service")).sync());
                break;
            }
            case "create": {
                String createidentity = params.get("identity_id");
                String createservice = params.get("service");
                String createtoken = params.get("token");
                Interface.printResponse(dataSift.account().createToken(createidentity, createservice, createtoken).sync());
                break;
            }
            case "update": {
                String targetid = params.get("identity_id");
                String targetservice = params.get("service");
                String newtoken = params.get("token");
                Interface.printResponse(dataSift.account().updateToken(targetid, targetservice, newtoken).sync());
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.account().deleteToken(params.get("identity_id"), params.get("service")).sync());
            }
        }
    }

    private static void executeLimit(DataSiftClient dataSift, String endpoint, HashMap<String, String> params) throws IOException {
        switch (endpoint) {
            case "list": {
                String service = params.get("service");
                int page = Integer.parseInt(Interface.getOrDefault(params, "page", "0"));
                int perpage = Integer.parseInt(Interface.getOrDefault(params, "per_page", "0"));
                Interface.printResponse(dataSift.account().listLimits(service, page, perpage).sync());
                break;
            }
            case "get": {
                Interface.printResponse(dataSift.account().getLimit(params.get("identity_id"), params.get("service")).sync());
                break;
            }
            case "create": {
                String createidentity = params.get("identity_id");
                String createservice = params.get("service");
                Long createallowance = Long.parseLong(params.get("total_allowance"));
                Interface.printResponse(dataSift.account().createLimit(createidentity, createservice, createallowance).sync());
                break;
            }
            case "update": {
                String updateidentity = params.get("identity_id");
                String updateservice = params.get("service");
                Long updateallowance = Long.parseLong(params.get("total_allowance"));
                Interface.printResponse(dataSift.account().updateLimit(updateidentity, updateservice, updateallowance).sync());
                break;
            }
            case "delete": {
                Interface.printResponse(dataSift.account().deleteLimit(params.get("identity_id"), params.get("service")).sync());
            }
        }
    }
}

