/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.pylon;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.ParamBuilder;
import com.datasift.client.pylon.PylonQuery;
import com.datasift.client.pylon.PylonResult;
import com.datasift.client.pylon.PylonStream;
import com.datasift.client.pylon.PylonStreamStatus;
import com.datasift.client.pylon.PylonStreamStatusList;
import com.datasift.client.pylon.PylonTags;
import com.datasift.client.pylon.PylonValidation;
import com.fasterxml.jackson.core.JsonProcessingException;
import io.higgs.http.client.JSONRequest;
import io.higgs.http.client.Request;
import io.higgs.http.client.readers.PageReader;
import io.higgs.http.client.readers.Reader;
import java.net.URI;

public class DataSiftPylon
extends DataSiftApiClient {
    public final String VALIDATE = "pylon/validate";
    public final String COMPILE = "pylon/compile";
    public final String START = "pylon/start";
    public final String STOP = "pylon/stop";
    public final String GET = "pylon/get";
    public final String ANALYZE = "pylon/analyze";
    public final String TAGS = "pylon/tags";

    public DataSiftPylon(DataSiftConfig config) {
        super(config);
    }

    public FutureData<PylonValidation> validate(String csdl) {
        FutureData<PylonValidation> future = new FutureData<PylonValidation>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/validate"));
        JSONRequest request = this.config.http().postJSON(uri, (Reader)new PageReader(this.newRequestCallback(future, new PylonValidation(), this.config))).addField("csdl", (Object)csdl);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<PylonStream> compile(String csdl) {
        FutureData<PylonStream> future = new FutureData<PylonStream>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/compile"));
        JSONRequest request = this.config.http().postJSON(uri, (Reader)new PageReader(this.newRequestCallback(future, new PylonStream(), this.config))).addField("csdl", (Object)csdl);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<DataSiftResult> start(String hash) {
        return this.start(hash, null);
    }

    public FutureData<DataSiftResult> start(String hash, String name) {
        if (hash == null || hash.isEmpty()) {
            throw new IllegalArgumentException("A valid hash is required to start a stream");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/start"));
        JSONRequest request = this.config.http().putJSON(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).addField("hash", (Object)hash).addField("name", (Object)name);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<DataSiftResult> stop(String hash) {
        if (hash == null || hash.isEmpty()) {
            throw new IllegalArgumentException("A valid hash is required to stop a stream");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/stop"));
        JSONRequest request = this.config.http().putJSON(uri, (Reader)new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).addField("hash", (Object)hash);
        this.performRequest(future, (Request)request);
        return future;
    }

    public FutureData<PylonStreamStatusList> get() {
        return this.get(0, 0);
    }

    public FutureData<PylonStreamStatusList> get(int page) {
        return this.get(page, 0);
    }

    public FutureData<PylonStreamStatusList> get(int page, int perPage) {
        FutureData<PylonStreamStatusList> future = new FutureData<PylonStreamStatusList>();
        ParamBuilder b = new ParamBuilder();
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI("pylon/get"));
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new PylonStreamStatusList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonStreamStatus> get(String hash) {
        URI uri = this.newParams().put("hash", hash).forURL(this.config.newAPIEndpointURI("pylon/get"));
        FutureData<PylonStreamStatus> future = new FutureData<PylonStreamStatus>();
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new PylonStreamStatus(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonResult> analyze(PylonQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("A valid analyze request body is required to analyze a stream");
        }
        FutureData<PylonResult> future = new FutureData<PylonResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/analyze"));
        try {
            JSONRequest result = this.config.http().postJSON(uri, (Reader)new PageReader(this.newRequestCallback(future, new PylonResult(), this.config))).setData((Object)query);
            this.performRequest(future, (Request)result);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Valid JSON is required to analyze a stream");
        }
        return future;
    }

    public FutureData<PylonTags> tags(String hash) {
        URI uri = this.newParams().put("hash", hash).forURL(this.config.newAPIEndpointURI("pylon/tags"));
        FutureData<PylonTags> future = new FutureData<PylonTags>();
        Request request = this.config.http().GET(uri, (Reader)new PageReader(this.newRequestCallback(future, new PylonTags(), this.config)));
        this.performRequest(future, request);
        return future;
    }
}

