/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;

public class S3
extends BaseConnector<S3> {
    public S3() {
        super(OutputType.S3_OUTPUT);
        this.setup(this, "auth.access_key", "auth.secret_key", "delivery_frequency", "max_size", "bucket", "acl");
    }

    public S3 format(S3OutputFormat format) {
        String strFormat;
        switch (format) {
            case JSON_ARRAY: {
                strFormat = "json_array";
                break;
            }
            case JSON_NEW_LINE: {
                strFormat = "json_new_line";
                break;
            }
            default: {
                strFormat = "json_meta";
            }
        }
        this.setParam("format", strFormat);
        return this;
    }

    public S3 accessKey(String key) {
        return (S3)this.setParam("auth.access_key", key);
    }

    public S3 secretKey(String secret) {
        return (S3)this.setParam("auth.secret_key", secret);
    }

    public S3 deliveryFrequency(int frequency) {
        return (S3)this.setParam("delivery_frequency", String.valueOf(frequency));
    }

    public S3 maxSize(int maxSize) {
        return (S3)this.setParam("max_size", String.valueOf(maxSize));
    }

    public S3 bucket(String bucket) {
        return (S3)this.setParam("bucket", bucket);
    }

    public S3 directory(String directory) {
        return (S3)this.setParam("directory", directory);
    }

    public S3 filePrefix(String prefix) {
        return (S3)this.setParam("file_prefix", prefix);
    }

    public S3 acl(String acl) {
        return (S3)this.setParam("acl", acl);
    }

    public S3 gzip() {
        return this.compression("gzip");
    }

    public S3 compression(String format) {
        return (S3)this.setParam("compression", format);
    }

    public static enum S3OutputFormat {
        JSON_META,
        JSON_ARRAY,
        JSON_NEW_LINE;


        public static S3OutputFormat fromStr(String str) {
            try {
                return S3OutputFormat.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return S3OutputFormat.valueOf(str);
            }
        }
    }
}

