/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.ParamBuilder;
import com.datasift.client.managedsource.ManagedDataSourceType;
import com.datasift.client.managedsource.ManagedSource;
import com.datasift.client.managedsource.ManagedSourceList;
import com.datasift.client.managedsource.ManagedSourceLog;
import com.datasift.client.managedsource.sources.BaseSource;
import com.datasift.client.managedsource.sources.DataSource;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.io.higgs.http.client.POST;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.PageReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;

public class DataSiftManagedSource
extends DataSiftApiClient {
    public static final String CREATE = "source/create";
    public static final String UPDATE = "source/update";
    public static final String START = "source/start";
    public static final String STOP = "source/stop";
    public static final String DELETE = "source/delete";
    public static final String GET = "source/get";
    public static final String LOG = "source/log";
    public static final String ADD_AUTH = "source/auth/add";
    public static final String REMOVE_AUTH = "source/auth/remove";
    public static final String ADD_RESOURCE = "source/resource/add";
    public static final String REMOVE_RESOURCE = "source/resource/remove";

    public DataSiftManagedSource(DataSiftConfig config) {
        super(config);
    }

    public <T extends DataSource> FutureData<ManagedSource> create(String name, T source) {
        return this.updateOrCreate(name, source, null);
    }

    public <T extends DataSource> FutureData<ManagedSource> create(String name, T source, boolean validate) {
        return this.updateOrCreate(name, source, null, validate);
    }

    public FutureData<ManagedSource> addAuth(String id, String ... resources) {
        return this.addAuth(id, true, resources);
    }

    public FutureData<ManagedSource> addAuth(String id, boolean validate, String ... resources) {
        if (id == null || resources == null || resources.length == 0) {
            throw new IllegalArgumentException("ID and a resource is required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(ADD_AUTH));
        try {
            ArrayList<ManagedSource.ResourceParams> list = new ArrayList<ManagedSource.ResourceParams>();
            for (String val : resources) {
                ManagedSource.ResourceParams params = new ManagedSource.ResourceParams();
                params.set("value", val);
                list.add(params);
            }
            POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("id", id).form("auth", DataSiftClient.MAPPER.writeValueAsString(list)).form("validate", DataSiftClient.MAPPER.writeValueAsString(Arrays.asList(validate)));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException jpe) {
            future.interuptCause(jpe);
            future.doNotify();
        }
        return future;
    }

    public FutureData<ManagedSource> removeAuth(String id, String ... resources) {
        if (id == null || resources == null || resources.length == 0) {
            throw new IllegalArgumentException("ID and a resource is required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(REMOVE_AUTH));
        try {
            POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("id", id).form("auth_ids", DataSiftClient.MAPPER.writeValueAsString(resources));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException jpe) {
            future.interuptCause(jpe);
            future.doNotify();
        }
        return future;
    }

    public FutureData<ManagedSource> addResource(String id, boolean validate, BaseSource.ResourceParams ... resources) {
        if (id == null || resources == null || resources.length == 0) {
            throw new IllegalArgumentException("ID and oen or more resources are required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(ADD_RESOURCE));
        POST request = null;
        try {
            request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("id", id).form("resources", DataSiftClient.MAPPER.writeValueAsString(resources)).form("validate", validate);
        }
        catch (JsonProcessingException e) {
            future.interuptCause(e);
            future.doNotify();
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<ManagedSource> removeResource(String id, String ... resources) {
        if (id == null || resources == null || resources.length == 0) {
            throw new IllegalArgumentException("ID and oen or more resources are required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(REMOVE_RESOURCE));
        POST request = null;
        try {
            request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("id", id).form("resource_ids", DataSiftClient.MAPPER.writeValueAsString(resources));
        }
        catch (JsonProcessingException e) {
            future.interuptCause(e);
            future.doNotify();
        }
        this.performRequest(future, request);
        return future;
    }

    public <T extends DataSource> FutureData<ManagedSource> update(String name, T source, ManagedSource id) {
        return this.update(name, source, id, false);
    }

    public <T extends DataSource> FutureData<ManagedSource> update(String name, T source, ManagedSource id, Boolean validate) {
        if (id == null) {
            throw new IllegalArgumentException("An existing managed source is required");
        }
        return this.updateOrCreate(name, source, id.getId(), validate);
    }

    protected <T extends DataSource> FutureData<ManagedSource> updateOrCreate(String name, T source, String id) {
        return this.updateOrCreate(name, source, id, false);
    }

    protected <T extends DataSource> FutureData<ManagedSource> updateOrCreate(String name, T source, String id, Boolean validate) {
        if (name == null || source == null) {
            throw new IllegalArgumentException("Name and a data source are both required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(id == null ? CREATE : UPDATE));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("source_type", source.type().value()).form("name", name);
        if (id != null) {
            request.form("id", id);
        }
        if (source.hasParams()) {
            request.form("parameters", source.getParametersAsJSON());
        }
        if (source.hasResources()) {
            request.form("resources", source.getResourcesAsJSON());
        }
        if (source.hasAuth()) {
            request.form("auth", source.getAuthAsJSON());
        }
        if (validate != null) {
            request.form("validate", validate);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> start(String id) {
        return this.start(ManagedSource.fromString(id));
    }

    public FutureData<DataSiftResult> start(ManagedSource source) {
        return this.start(FutureData.wrap(source));
    }

    public FutureData<DataSiftResult> start(FutureData<ManagedSource> source) {
        if (source == null) {
            throw new IllegalArgumentException("A data source is required");
        }
        final FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        BaseDataSiftResult res = new BaseDataSiftResult();
        this.unwrapFuture(source, future, res, new FutureResponse<ManagedSource>(){

            @Override
            public void apply(ManagedSource data) {
                URI uri = DataSiftManagedSource.this.newParams().forURL(DataSiftManagedSource.this.config.newAPIEndpointURI(DataSiftManagedSource.START));
                POST request = DataSiftManagedSource.this.config.http().POST(uri, new PageReader(DataSiftManagedSource.this.newRequestCallback(future, data, DataSiftManagedSource.this.config))).form("id", data.getId());
                DataSiftManagedSource.this.performRequest(future, request);
            }
        });
        return future;
    }

    public FutureData<ManagedSource> stop(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A data source is required");
        }
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(STOP));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> delete(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A data source is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI(DELETE));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<ManagedSourceList> get() {
        return this.get(null, 0, 0);
    }

    public FutureData<ManagedSourceList> get(int page) {
        return this.get(null, page, 0);
    }

    public FutureData<ManagedSourceList> get(int page, int perPage) {
        return this.get(null, page, perPage);
    }

    public FutureData<ManagedSourceList> get(ManagedDataSourceType type, int page, int perPage) {
        FutureData<ManagedSourceList> future = new FutureData<ManagedSourceList>();
        ParamBuilder b = this.newParams();
        if (type != null) {
            b.put("source_type", type.value());
        }
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI(GET));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new ManagedSourceList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<ManagedSource> get(String id) {
        FutureData<ManagedSource> future = new FutureData<ManagedSource>();
        URI uri = this.newParams().put("id", id).forURL(this.config.newAPIEndpointURI(GET));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new ManagedSource(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<ManagedSourceLog> log(String id) {
        return this.log(id, 0, 0);
    }

    public FutureData<ManagedSourceLog> log(String id, int page) {
        return this.log(id, page, 0);
    }

    public FutureData<ManagedSourceLog> log(String id, int page, int perPage) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A valid source ID is required");
        }
        FutureData<ManagedSourceLog> future = new FutureData<ManagedSourceLog>();
        ParamBuilder b = this.newParams().put("id", id);
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI(LOG));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new ManagedSourceLog(), this.config)));
        this.performRequest(future, request);
        return future;
    }
}

