/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push;

import com.datasift.shaded.com.fasterxml.jackson.annotation.JsonValue;

public enum Status {
    ACTIVE("active"),
    PAUSED("paused"),
    WAITING_FOR_START("waiting_for_start"),
    RETRYING("retrying"),
    FAILED("failed"),
    FINISHING("finishing"),
    FINISHED("finished"),
    FINISHING_PAUSED("finishing_paused");

    private final String value;

    private Status(String value) {
        this.value = value.toLowerCase();
    }

    @JsonValue
    public String val() {
        return this.value;
    }

    public boolean isPaused() {
        return this.is(PAUSED);
    }

    public boolean isActive() {
        return this.is(ACTIVE);
    }

    public boolean isWaitingForStart() {
        return this.is(WAITING_FOR_START);
    }

    public boolean isRetrying() {
        return this.is(RETRYING);
    }

    public boolean isFailed() {
        return this.is(FAILED);
    }

    public boolean isFinishing() {
        return this.is(FINISHING);
    }

    public boolean isFinishingPaused() {
        return this.is(FINISHING_PAUSED);
    }

    public boolean isFinished() {
        return this.is(FINISHED);
    }

    private boolean is(Status s) {
        return s.val().equalsIgnoreCase(this.val());
    }

    public String toString() {
        return this.val();
    }
}

