/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.pylon;

import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.FutureData;
import com.datasift.client.ParamBuilder;
import com.datasift.client.pylon.PylonTaskAnalyzeResponse;
import com.datasift.client.pylon.PylonTaskRequest;
import com.datasift.client.pylon.PylonTaskResult;
import com.datasift.client.pylon.PylonTaskResultList;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.io.higgs.http.client.JSONRequest;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.PageReader;
import java.net.URI;

public class DataSiftPylonTask
extends DataSiftApiClient {
    protected static final String service = "linkedin";
    public final String TASK = "pylon/linkedin/task/";

    public DataSiftPylonTask(DataSiftConfig config) {
        super(config);
    }

    public FutureData<PylonTaskResultList> get(int page, int perPage) {
        FutureData<PylonTaskResultList> future = new FutureData<PylonTaskResultList>();
        ParamBuilder b = new ParamBuilder();
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI("pylon/linkedin/task/"));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new PylonTaskResultList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonTaskResult> get(String id) {
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/linkedin/task/" + id));
        FutureData<PylonTaskResult> future = new FutureData<PylonTaskResult>();
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new PylonTaskResult(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonTaskAnalyzeResponse> analyze(PylonTaskRequest query) {
        if (query == null) {
            throw new IllegalArgumentException("A valid analyze request body is required to analyze a stream");
        }
        FutureData<PylonTaskAnalyzeResponse> future = new FutureData<PylonTaskAnalyzeResponse>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/linkedin/task/"));
        try {
            JSONRequest result = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new PylonTaskAnalyzeResponse(), this.config))).setData(query);
            this.performRequest(future, result);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Valid JSON is required to analyze a stream");
        }
        return future;
    }
}

