/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.com.fasterxml.jackson.databind;

import com.datasift.shaded.com.fasterxml.jackson.core.Base64Variant;
import com.datasift.shaded.com.fasterxml.jackson.core.FormatSchema;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonEncoding;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonFactory;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonParser;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.com.fasterxml.jackson.core.PrettyPrinter;
import com.datasift.shaded.com.fasterxml.jackson.core.Version;
import com.datasift.shaded.com.fasterxml.jackson.core.Versioned;
import com.datasift.shaded.com.fasterxml.jackson.core.io.SegmentedStringWriter;
import com.datasift.shaded.com.fasterxml.jackson.core.type.TypeReference;
import com.datasift.shaded.com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.datasift.shaded.com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.datasift.shaded.com.fasterxml.jackson.core.util.Instantiatable;
import com.datasift.shaded.com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.datasift.shaded.com.fasterxml.jackson.databind.JavaType;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.MapperFeature;
import com.datasift.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.datasift.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import com.datasift.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.datasift.shaded.com.fasterxml.jackson.databind.cfg.DatabindVersion;
import com.datasift.shaded.com.fasterxml.jackson.databind.cfg.MapperConfigBase;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.DefaultSerializerProvider;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.FilterProvider;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.SerializerFactory;
import com.datasift.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectWriter
implements Versioned,
Serializable {
    private static final long serialVersionUID = -7024829992408267532L;
    protected static final PrettyPrinter NULL_PRETTY_PRINTER = new MinimalPrettyPrinter();
    protected final SerializationConfig _config;
    protected final DefaultSerializerProvider _serializerProvider;
    protected final SerializerFactory _serializerFactory;
    protected final JsonFactory _jsonFactory;
    protected final JavaType _rootType;
    protected final JsonSerializer<Object> _rootSerializer;
    protected final PrettyPrinter _prettyPrinter;
    protected final FormatSchema _schema;

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config, JavaType rootType, PrettyPrinter pp) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._jsonFactory = mapper._jsonFactory;
        this._rootType = rootType;
        this._prettyPrinter = pp;
        this._schema = null;
        this._rootSerializer = this._prefetchRootSerializer(config, rootType);
    }

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._jsonFactory = mapper._jsonFactory;
        this._rootType = null;
        this._rootSerializer = null;
        this._prettyPrinter = null;
        this._schema = null;
    }

    protected ObjectWriter(ObjectMapper mapper, SerializationConfig config, FormatSchema s) {
        this._config = config;
        this._serializerProvider = mapper._serializerProvider;
        this._serializerFactory = mapper._serializerFactory;
        this._jsonFactory = mapper._jsonFactory;
        this._rootType = null;
        this._rootSerializer = null;
        this._prettyPrinter = null;
        this._schema = s;
    }

    protected ObjectWriter(ObjectWriter base, SerializationConfig config, JavaType rootType, JsonSerializer<Object> rootSer, PrettyPrinter pp, FormatSchema s) {
        this._config = config;
        this._serializerProvider = base._serializerProvider;
        this._serializerFactory = base._serializerFactory;
        this._jsonFactory = base._jsonFactory;
        this._rootType = rootType;
        this._rootSerializer = rootSer;
        this._prettyPrinter = pp;
        this._schema = s;
    }

    protected ObjectWriter(ObjectWriter base, SerializationConfig config) {
        this._config = config;
        this._serializerProvider = base._serializerProvider;
        this._serializerFactory = base._serializerFactory;
        this._jsonFactory = base._jsonFactory;
        this._schema = base._schema;
        this._rootType = base._rootType;
        this._rootSerializer = base._rootSerializer;
        this._prettyPrinter = base._prettyPrinter;
    }

    @Override
    public Version version() {
        return DatabindVersion.instance.version();
    }

    public ObjectWriter with(SerializationFeature feature) {
        SerializationConfig newConfig = this._config.with(feature);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter with(SerializationFeature first, SerializationFeature ... other) {
        SerializationConfig newConfig = this._config.with(first, other);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter withFeatures(SerializationFeature ... features) {
        SerializationConfig newConfig = this._config.withFeatures(features);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter without(SerializationFeature feature) {
        SerializationConfig newConfig = this._config.without(feature);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter without(SerializationFeature first, SerializationFeature ... other) {
        SerializationConfig newConfig = this._config.without(first, other);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter withoutFeatures(SerializationFeature ... features) {
        SerializationConfig newConfig = this._config.withoutFeatures(features);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter with(DateFormat df) {
        SerializationConfig newConfig = this._config.with(df);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter withDefaultPrettyPrinter() {
        return this.with(new DefaultPrettyPrinter());
    }

    public ObjectWriter with(FilterProvider filterProvider) {
        if (filterProvider == this._config.getFilterProvider()) {
            return this;
        }
        return new ObjectWriter(this, this._config.withFilters(filterProvider));
    }

    public ObjectWriter with(PrettyPrinter pp) {
        if (pp == this._prettyPrinter) {
            return this;
        }
        if (pp == null) {
            pp = NULL_PRETTY_PRINTER;
        }
        return new ObjectWriter(this, this._config, this._rootType, this._rootSerializer, pp, this._schema);
    }

    public ObjectWriter withRootName(String rootName) {
        SerializationConfig newConfig = this._config.withRootName(rootName);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter withSchema(FormatSchema schema) {
        return this._schema == schema ? this : new ObjectWriter(this, this._config, this._rootType, this._rootSerializer, this._prettyPrinter, schema);
    }

    public ObjectWriter withType(JavaType rootType) {
        JsonSerializer<Object> rootSer = this._prefetchRootSerializer(this._config, rootType);
        return rootType == this._rootType ? this : new ObjectWriter(this, this._config, rootType, rootSer, this._prettyPrinter, this._schema);
    }

    public ObjectWriter withType(Class<?> rootType) {
        return this.withType(this._config.constructType(rootType));
    }

    public ObjectWriter withType(TypeReference<?> rootType) {
        return this.withType(this._config.getTypeFactory().constructType(rootType.getType()));
    }

    public ObjectWriter withView(Class<?> view) {
        MapperConfigBase newConfig = this._config.withView((Class)view);
        return newConfig == this._config ? this : new ObjectWriter(this, (SerializationConfig)newConfig);
    }

    public ObjectWriter with(Locale l) {
        SerializationConfig newConfig = this._config.with(l);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter with(TimeZone tz) {
        SerializationConfig newConfig = this._config.with(tz);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public ObjectWriter with(Base64Variant b64variant) {
        SerializationConfig newConfig = this._config.with(b64variant);
        return newConfig == this._config ? this : new ObjectWriter(this, newConfig);
    }

    public boolean isEnabled(SerializationFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(MapperFeature f) {
        return this._config.isEnabled(f);
    }

    public boolean isEnabled(JsonParser.Feature f) {
        return this._jsonFactory.isEnabled(f);
    }

    public JsonFactory getJsonFactory() {
        return this._jsonFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public void writeValue(JsonGenerator jgen, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        this._configureJsonGenerator(jgen);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseableValue(jgen, value, this._config);
        } else {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jgen, value);
            } else {
                this._serializerProvider(this._config).serializeValue(jgen, value, this._rootType, this._rootSerializer);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jgen.flush();
            }
        }
    }

    public void writeValue(File resultFile, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(resultFile, JsonEncoding.UTF8), value);
    }

    public void writeValue(OutputStream out, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(out, JsonEncoding.UTF8), value);
    }

    public void writeValue(Writer w, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        this._configAndWriteValue(this._jsonFactory.createJsonGenerator(w), value);
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        SegmentedStringWriter sw = new SegmentedStringWriter(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createJsonGenerator(sw), value);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
        return sw.getAndClear();
    }

    public byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        ByteArrayBuilder bb = new ByteArrayBuilder(this._jsonFactory._getBufferRecycler());
        try {
            this._configAndWriteValue(this._jsonFactory.createJsonGenerator(bb, JsonEncoding.UTF8), value);
        }
        catch (JsonProcessingException e) {
            throw e;
        }
        catch (IOException e) {
            throw JsonMappingException.fromUnexpectedIOE(e);
        }
        byte[] result = bb.toByteArray();
        bb.release();
        return result;
    }

    public boolean canSerialize(Class<?> type) {
        return this._serializerProvider(this._config).hasSerializerFor(type);
    }

    protected DefaultSerializerProvider _serializerProvider(SerializationConfig config) {
        return this._serializerProvider.createInstance(config, this._serializerFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void _configAndWriteValue(JsonGenerator jgen, Object value) throws IOException, JsonGenerationException, JsonMappingException {
        this._configureJsonGenerator(jgen);
        if (this._config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseable(jgen, value, this._config);
            return;
        }
        boolean closed = false;
        try {
            if (this._rootType == null) {
                this._serializerProvider(this._config).serializeValue(jgen, value);
            } else {
                this._serializerProvider(this._config).serializeValue(jgen, value, this._rootType, this._rootSerializer);
            }
            closed = true;
            jgen.close();
        }
        finally {
            if (!closed) {
                try {
                    jgen.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseable(JsonGenerator jgen, Object value, SerializationConfig cfg) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable toClose = (Closeable)value;
        try {
            if (this._rootType == null) {
                this._serializerProvider(cfg).serializeValue(jgen, value);
            } else {
                this._serializerProvider(cfg).serializeValue(jgen, value, this._rootType, this._rootSerializer);
            }
            JsonGenerator tmpJgen = jgen;
            jgen = null;
            tmpJgen.close();
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        finally {
            if (jgen != null) {
                try {
                    jgen.close();
                }
                catch (IOException ioe) {}
            }
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void _writeCloseableValue(JsonGenerator jgen, Object value, SerializationConfig cfg) throws IOException, JsonGenerationException, JsonMappingException {
        Closeable toClose = (Closeable)value;
        try {
            if (this._rootType == null) {
                this._serializerProvider(cfg).serializeValue(jgen, value);
            } else {
                this._serializerProvider(cfg).serializeValue(jgen, value, this._rootType, this._rootSerializer);
            }
            if (this._config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                jgen.flush();
            }
            Closeable tmpToClose = toClose;
            toClose = null;
            tmpToClose.close();
        }
        finally {
            if (toClose != null) {
                try {
                    toClose.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    protected final JsonSerializer<Object> _prefetchRootSerializer(SerializationConfig config, JavaType valueType) {
        if (valueType == null || !this._config.isEnabled(SerializationFeature.EAGER_SERIALIZER_FETCH)) {
            return null;
        }
        try {
            return this._serializerProvider(config).findTypedValueSerializer(valueType, true, null);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    private final void _configureJsonGenerator(JsonGenerator jgen) {
        if (this._prettyPrinter != null) {
            PrettyPrinter pp = this._prettyPrinter;
            if (pp == NULL_PRETTY_PRINTER) {
                jgen.setPrettyPrinter(null);
            } else {
                if (pp instanceof Instantiatable) {
                    pp = (PrettyPrinter)((Instantiatable)((Object)pp)).createInstance();
                }
                jgen.setPrettyPrinter(pp);
            }
        } else if (this._config.isEnabled(SerializationFeature.INDENT_OUTPUT)) {
            jgen.useDefaultPrettyPrinter();
        }
        if (this._schema != null) {
            jgen.setSchema(this._schema);
        }
    }
}

