/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.com.fasterxml.jackson.databind.ser;

import com.datasift.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.datasift.shaded.com.fasterxml.jackson.core.io.SerializedString;
import com.datasift.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.datasift.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.datasift.shaded.com.fasterxml.jackson.databind.JavaType;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsonschema.JsonSchema;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsonschema.SchemaAware;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.impl.PropertySerializerMap;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.impl.UnwrappingBeanPropertyWriter;
import com.datasift.shaded.com.fasterxml.jackson.databind.util.Annotations;
import com.datasift.shaded.com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanPropertyWriter
implements BeanProperty {
    public static final Object MARKER_FOR_EMPTY = new Object();
    protected final AnnotatedMember _member;
    protected final Annotations _contextAnnotations;
    protected final JavaType _declaredType;
    protected final Method _accessorMethod;
    protected final Field _field;
    protected HashMap<Object, Object> _internalSettings;
    protected final SerializedString _name;
    protected final JavaType _cfgSerializationType;
    protected JsonSerializer<Object> _serializer;
    protected JsonSerializer<Object> _nullSerializer;
    protected PropertySerializerMap _dynamicSerializers;
    protected final boolean _suppressNulls;
    protected final Object _suppressableValue;
    protected final Class<?>[] _includeInViews;
    protected TypeSerializer _typeSerializer;
    protected JavaType _nonTrivialBaseType;

    public BeanPropertyWriter(BeanPropertyDefinition propDef, AnnotatedMember member, Annotations contextAnnotations, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, JavaType serType, boolean suppressNulls, Object suppressableValue) {
        this._member = member;
        this._contextAnnotations = contextAnnotations;
        this._name = new SerializedString(propDef.getName());
        this._declaredType = declaredType;
        this._serializer = ser;
        this._dynamicSerializers = ser == null ? PropertySerializerMap.emptyMap() : null;
        this._typeSerializer = typeSer;
        this._cfgSerializationType = serType;
        if (member instanceof AnnotatedField) {
            this._accessorMethod = null;
            this._field = (Field)member.getMember();
        } else if (member instanceof AnnotatedMethod) {
            this._accessorMethod = (Method)member.getMember();
            this._field = null;
        } else {
            throw new IllegalArgumentException("Can not pass member of type " + member.getClass().getName());
        }
        this._suppressNulls = suppressNulls;
        this._suppressableValue = suppressableValue;
        this._includeInViews = propDef.findViews();
        this._nullSerializer = null;
    }

    protected BeanPropertyWriter(BeanPropertyWriter base) {
        this(base, base._name);
    }

    protected BeanPropertyWriter(BeanPropertyWriter base, SerializedString name) {
        this._name = name;
        this._member = base._member;
        this._contextAnnotations = base._contextAnnotations;
        this._declaredType = base._declaredType;
        this._accessorMethod = base._accessorMethod;
        this._field = base._field;
        this._serializer = base._serializer;
        this._nullSerializer = base._nullSerializer;
        if (base._internalSettings != null) {
            this._internalSettings = new HashMap<Object, Object>(base._internalSettings);
        }
        this._cfgSerializationType = base._cfgSerializationType;
        this._dynamicSerializers = base._dynamicSerializers;
        this._suppressNulls = base._suppressNulls;
        this._suppressableValue = base._suppressableValue;
        this._includeInViews = base._includeInViews;
        this._typeSerializer = base._typeSerializer;
        this._nonTrivialBaseType = base._nonTrivialBaseType;
    }

    public BeanPropertyWriter rename(NameTransformer transformer) {
        String newName = transformer.transform(this._name.getValue());
        if (newName.equals(this._name.toString())) {
            return this;
        }
        return new BeanPropertyWriter(this, new SerializedString(newName));
    }

    public void assignSerializer(JsonSerializer<Object> ser) {
        if (this._serializer != null && this._serializer != ser) {
            throw new IllegalStateException("Can not override serializer");
        }
        this._serializer = ser;
    }

    public void assignNullSerializer(JsonSerializer<Object> nullSer) {
        if (this._nullSerializer != null && this._nullSerializer != nullSer) {
            throw new IllegalStateException("Can not override null serializer");
        }
        this._nullSerializer = nullSer;
    }

    public BeanPropertyWriter unwrappingWriter(NameTransformer unwrapper) {
        return new UnwrappingBeanPropertyWriter(this, unwrapper);
    }

    public void setNonTrivialBaseType(JavaType t) {
        this._nonTrivialBaseType = t;
    }

    @Override
    public String getName() {
        return this._name.getValue();
    }

    @Override
    public JavaType getType() {
        return this._declaredType;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._member.getAnnotation(acls);
    }

    @Override
    public <A extends Annotation> A getContextAnnotation(Class<A> acls) {
        return this._contextAnnotations.get(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._member;
    }

    public Object getInternalSetting(Object key) {
        if (this._internalSettings == null) {
            return null;
        }
        return this._internalSettings.get(key);
    }

    public Object setInternalSetting(Object key, Object value) {
        if (this._internalSettings == null) {
            this._internalSettings = new HashMap();
        }
        return this._internalSettings.put(key, value);
    }

    public Object removeInternalSetting(Object key) {
        Object removed = null;
        if (this._internalSettings != null) {
            removed = this._internalSettings.remove(key);
            if (this._internalSettings.size() == 0) {
                this._internalSettings = null;
            }
        }
        return removed;
    }

    public SerializedString getSerializedName() {
        return this._name;
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    public boolean hasNullSerializer() {
        return this._nullSerializer != null;
    }

    public boolean willSuppressNulls() {
        return this._suppressNulls;
    }

    public JsonSerializer<Object> getSerializer() {
        return this._serializer;
    }

    public JavaType getSerializationType() {
        return this._cfgSerializationType;
    }

    public Class<?> getRawSerializationType() {
        return this._cfgSerializationType == null ? null : this._cfgSerializationType.getRawClass();
    }

    public Class<?> getPropertyType() {
        if (this._accessorMethod != null) {
            return this._accessorMethod.getReturnType();
        }
        return this._field.getType();
    }

    public Type getGenericPropertyType() {
        if (this._accessorMethod != null) {
            return this._accessorMethod.getGenericReturnType();
        }
        return this._field.getGenericType();
    }

    public Class<?>[] getViews() {
        return this._includeInViews;
    }

    protected boolean isRequired(AnnotationIntrospector intr) {
        Boolean value = intr.hasRequiredMarker(this._member);
        return value == null ? false : value;
    }

    public void depositSchemaProperty(JsonObjectFormatVisitor objectVisitor) throws JsonMappingException {
        if (this.isRequired(objectVisitor.getProvider().getAnnotationIntrospector())) {
            objectVisitor.property(this);
        } else {
            objectVisitor.optionalProperty(this);
        }
    }

    public void depositSchemaProperty(ObjectNode propertiesNode, SerializerProvider provider) throws JsonMappingException {
        JavaType propType = this.getSerializationType();
        Class<?> hint = propType == null ? this.getGenericPropertyType() : propType.getRawClass();
        JsonSerializer<Object> ser = this.getSerializer();
        if (ser == null) {
            Class<?> serType = this.getRawSerializationType();
            if (serType == null) {
                serType = this.getPropertyType();
            }
            ser = provider.findValueSerializer(serType, (BeanProperty)this);
        }
        boolean isOptional = !this.isRequired(provider.getAnnotationIntrospector());
        JsonNode schemaNode = ser instanceof SchemaAware ? ((SchemaAware)((Object)ser)).getSchema(provider, hint, isOptional) : JsonSchema.getDefaultSchemaNode();
        propertiesNode.put(this.getName(), schemaNode);
    }

    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value = this.get(bean);
        if (value == null) {
            if (this._nullSerializer != null) {
                jgen.writeFieldName(this._name);
                this._nullSerializer.serialize(null, jgen, prov);
            }
            return;
        }
        JsonSerializer<Object> ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean) {
            this._handleSelfReference(bean, ser);
        }
        jgen.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, jgen, prov);
        } else {
            ser.serializeWithType(value, jgen, prov, this._typeSerializer);
        }
    }

    public void serializeAsColumn(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        JsonSerializer<Object> ser;
        Object value = this.get(bean);
        if (value == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, jgen, prov);
            } else {
                jgen.writeNull();
            }
        }
        if ((ser = this._serializer) == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (ser.isEmpty(value)) {
                    this.serializeAsPlaceholder(bean, jgen, prov);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsPlaceholder(bean, jgen, prov);
                return;
            }
        }
        if (value == bean) {
            this._handleSelfReference(bean, ser);
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, jgen, prov);
        } else {
            ser.serializeWithType(value, jgen, prov, this._typeSerializer);
        }
    }

    public void serializeAsPlaceholder(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        if (this._nullSerializer != null) {
            this._nullSerializer.serialize(null, jgen, prov);
        } else {
            jgen.writeNull();
        }
    }

    protected JsonSerializer<Object> _findAndAddDynamic(PropertySerializerMap map, Class<?> type, SerializerProvider provider) throws JsonMappingException {
        PropertySerializerMap.SerializerAndMapResult result;
        if (this._nonTrivialBaseType != null) {
            JavaType t = provider.constructSpecializedType(this._nonTrivialBaseType, type);
            result = map.findAndAddSerializer(t, provider, (BeanProperty)this);
        } else {
            result = map.findAndAddSerializer(type, provider, (BeanProperty)this);
        }
        if (map != result.map) {
            this._dynamicSerializers = result.map;
        }
        return result.serializer;
    }

    public final Object get(Object bean) throws Exception {
        if (this._accessorMethod != null) {
            return this._accessorMethod.invoke(bean, new Object[0]);
        }
        return this._field.get(bean);
    }

    protected void _handleSelfReference(Object bean, JsonSerializer<?> ser) throws JsonMappingException {
        if (ser.usesObjectId()) {
            return;
        }
        throw new JsonMappingException("Direct self-reference leading to cycle");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        sb.append("property '").append(this.getName()).append("' (");
        if (this._accessorMethod != null) {
            sb.append("via method ").append(this._accessorMethod.getDeclaringClass().getName()).append("#").append(this._accessorMethod.getName());
        } else {
            sb.append("field \"").append(this._field.getDeclaringClass().getName()).append("#").append(this._field.getName());
        }
        if (this._serializer == null) {
            sb.append(", no static serializer");
        } else {
            sb.append(", static serializer of type " + this._serializer.getClass().getName());
        }
        sb.append(')');
        return sb.toString();
    }
}

