/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.com.fasterxml.jackson.databind.ser;

import com.datasift.shaded.com.fasterxml.jackson.annotation.JsonInclude;
import com.datasift.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.datasift.shaded.com.fasterxml.jackson.databind.BeanDescription;
import com.datasift.shaded.com.fasterxml.jackson.databind.JavaType;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.SerializationConfig;
import com.datasift.shaded.com.fasterxml.jackson.databind.SerializationFeature;
import com.datasift.shaded.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.Annotated;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.BeanSerializerFactory;
import com.datasift.shaded.com.fasterxml.jackson.databind.util.Annotations;
import com.datasift.shaded.com.fasterxml.jackson.databind.util.Comparators;
import com.datasift.shaded.com.fasterxml.jackson.databind.util.NameTransformer;
import java.lang.reflect.AnnotatedElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyBuilder {
    protected final SerializationConfig _config;
    protected final BeanDescription _beanDesc;
    protected final JsonInclude.Include _outputProps;
    protected final AnnotationIntrospector _annotationIntrospector;
    protected Object _defaultBean;

    public PropertyBuilder(SerializationConfig config, BeanDescription beanDesc) {
        this._config = config;
        this._beanDesc = beanDesc;
        this._outputProps = beanDesc.findSerializationInclusion(config.getSerializationInclusion());
        this._annotationIntrospector = this._config.getAnnotationIntrospector();
    }

    public Annotations getClassAnnotations() {
        return this._beanDesc.getClassAnnotations();
    }

    protected BeanPropertyWriter buildWriter(BeanPropertyDefinition propDef, JavaType declaredType, JsonSerializer<?> ser, TypeSerializer typeSer, TypeSerializer contentTypeSer, AnnotatedMember am, boolean defaultUseStaticTyping) {
        JavaType serializationType = this.findSerializationType(am, defaultUseStaticTyping, declaredType);
        if (contentTypeSer != null) {
            JavaType ct;
            if (serializationType == null) {
                serializationType = declaredType;
            }
            if ((ct = serializationType.getContentType()) == null) {
                throw new IllegalStateException("Problem trying to create BeanPropertyWriter for property '" + propDef.getName() + "' (of type " + this._beanDesc.getType() + "); serialization type " + serializationType + " has no content");
            }
            serializationType = serializationType.withContentTypeHandler(contentTypeSer);
            ct = serializationType.getContentType();
        }
        Object valueToSuppress = null;
        boolean suppressNulls = false;
        JsonInclude.Include methodProps = this._annotationIntrospector.findSerializationInclusion(am, this._outputProps);
        if (methodProps != null) {
            switch (methodProps) {
                case NON_DEFAULT: {
                    valueToSuppress = this.getDefaultValue(propDef.getName(), am);
                    if (valueToSuppress == null) {
                        suppressNulls = true;
                        break;
                    }
                    if (!valueToSuppress.getClass().isArray()) break;
                    valueToSuppress = Comparators.getArrayComparator(valueToSuppress);
                    break;
                }
                case NON_EMPTY: {
                    suppressNulls = true;
                    valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                    break;
                }
                case NON_NULL: {
                    suppressNulls = true;
                }
                case ALWAYS: {
                    if (!declaredType.isContainerType() || this._config.isEnabled(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS)) break;
                    valueToSuppress = BeanPropertyWriter.MARKER_FOR_EMPTY;
                }
            }
        }
        BeanPropertyWriter bpw = new BeanPropertyWriter(propDef, am, this._beanDesc.getClassAnnotations(), declaredType, ser, typeSer, serializationType, suppressNulls, valueToSuppress);
        NameTransformer unwrapper = this._annotationIntrospector.findUnwrappingNameTransformer(am);
        if (unwrapper != null) {
            bpw = bpw.unwrappingWriter(unwrapper);
        }
        return bpw;
    }

    protected JavaType findSerializationType(Annotated a, boolean useStaticTyping, JavaType declaredType) {
        JsonSerialize.Typing typing;
        JavaType secondary;
        Class<?> serClass = this._annotationIntrospector.findSerializationType(a);
        if (serClass != null) {
            Class<?> rawDeclared = declaredType.getRawClass();
            if (serClass.isAssignableFrom(rawDeclared)) {
                declaredType = declaredType.widenBy(serClass);
            } else {
                if (!rawDeclared.isAssignableFrom(serClass)) {
                    throw new IllegalArgumentException("Illegal concrete-type annotation for method '" + a.getName() + "': class " + serClass.getName() + " not a super-type of (declared) class " + rawDeclared.getName());
                }
                declaredType = this._config.constructSpecializedType(declaredType, serClass);
            }
            useStaticTyping = true;
        }
        if ((secondary = BeanSerializerFactory.modifySecondaryTypesByAnnotation(this._config, a, declaredType)) != declaredType) {
            useStaticTyping = true;
            declaredType = secondary;
        }
        if (!useStaticTyping && (typing = this._annotationIntrospector.findSerializationTyping(a)) != null) {
            useStaticTyping = typing == JsonSerialize.Typing.STATIC;
        }
        return useStaticTyping ? declaredType : null;
    }

    protected Object getDefaultBean() {
        if (this._defaultBean == null) {
            this._defaultBean = this._beanDesc.instantiateBean(this._config.canOverrideAccessModifiers());
            if (this._defaultBean == null) {
                AnnotatedElement cls = this._beanDesc.getClassInfo().getAnnotated();
                throw new IllegalArgumentException("Class " + ((Class)cls).getName() + " has no default constructor; can not instantiate default bean value to support 'properties=JsonSerialize.Inclusion.NON_DEFAULT' annotation");
            }
        }
        return this._defaultBean;
    }

    protected Object getDefaultValue(String name, AnnotatedMember member) {
        Object defaultBean = this.getDefaultBean();
        try {
            return member.getValue(defaultBean);
        }
        catch (Exception e) {
            return this._throwWrapped(e, name, defaultBean);
        }
    }

    protected Object _throwWrapped(Exception e, String propName, Object defaultBean) {
        Throwable t = e;
        while (t.getCause() != null) {
            t = t.getCause();
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new IllegalArgumentException("Failed to get property '" + propName + "' of default " + defaultBean.getClass().getName() + " instance");
    }
}

