/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.com.fasterxml.jackson.databind.util;

import com.datasift.shaded.com.fasterxml.jackson.core.io.SerializedString;
import com.datasift.shaded.com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.datasift.shaded.com.fasterxml.jackson.databind.BeanDescription;
import com.datasift.shaded.com.fasterxml.jackson.databind.JavaType;
import com.datasift.shaded.com.fasterxml.jackson.databind.PropertyName;
import com.datasift.shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.datasift.shaded.com.fasterxml.jackson.databind.type.ClassKey;
import com.datasift.shaded.com.fasterxml.jackson.databind.util.LRUMap;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNameLookup
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected LRUMap<ClassKey, SerializedString> _rootNames;

    public SerializedString findRootName(JavaType rootType, MapperConfig<?> config) {
        return this.findRootName(rootType.getRawClass(), config);
    }

    public synchronized SerializedString findRootName(Class<?> rootType, MapperConfig<?> config) {
        ClassKey key = new ClassKey(rootType);
        if (this._rootNames == null) {
            this._rootNames = new LRUMap(20, 200);
        } else {
            SerializedString name = (SerializedString)this._rootNames.get(key);
            if (name != null) {
                return name;
            }
        }
        BeanDescription beanDesc = config.introspectClassAnnotations(rootType);
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        AnnotatedClass ac = beanDesc.getClassInfo();
        PropertyName pname = intr.findRootName(ac);
        String nameStr = pname == null || !pname.hasSimpleName() ? rootType.getSimpleName() : pname.getSimpleName();
        SerializedString name = new SerializedString(nameStr);
        this._rootNames.put(key, name);
        return name;
    }
}

