/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client;

import com.datasift.shaded.io.higgs.http.client.ClientIntializer;
import com.datasift.shaded.io.higgs.http.client.ProxyConnectionException;
import com.datasift.shaded.io.netty.channel.ChannelHandlerContext;
import com.datasift.shaded.io.netty.channel.ChannelPipeline;
import com.datasift.shaded.io.netty.channel.SimpleChannelInboundHandler;
import com.datasift.shaded.io.netty.handler.codec.http.HttpRequest;
import com.datasift.shaded.io.netty.handler.codec.http.HttpResponse;
import com.datasift.shaded.io.netty.handler.codec.http.LastHttpContent;

public class ConnectHandler
extends SimpleChannelInboundHandler<Object> {
    protected final HttpRequest request;
    protected final boolean tunneling;
    protected final SimpleChannelInboundHandler<Object> handler;
    private final InitFactory factory;

    public ConnectHandler(boolean ssl, HttpRequest request, SimpleChannelInboundHandler<Object> handler, InitFactory factory) {
        this.tunneling = ssl;
        this.request = request;
        this.handler = handler;
        this.factory = factory;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            int code = res.getStatus().code();
            if (code > 199 && code < 300) {
                if (this.tunneling) {
                    ClientIntializer.addSSL(ctx.pipeline(), true, null);
                }
            } else {
                throw new ProxyConnectionException("Proxy server indicated it was unable to establish a secure connection to the origin server", res);
            }
        }
        if (msg instanceof LastHttpContent) {
            ctx.pipeline().remove(this);
            ChannelPipeline pipeline = ctx.pipeline();
            this.factory.newInstance(false, this.handler, null).configurePipeline(pipeline);
            this.writeOriginalRequest(ctx);
        }
    }

    protected void writeOriginalRequest(ChannelHandlerContext ctx) {
        ctx.channel().writeAndFlush(this.request);
    }

    public static interface InitFactory {
        public ClientIntializer newInstance(boolean var1, SimpleChannelInboundHandler<Object> var2, ConnectHandler var3);
    }
}

