/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client.readers;

import com.datasift.shaded.io.higgs.core.func.Function2;
import com.datasift.shaded.io.higgs.http.client.Response;
import com.datasift.shaded.io.netty.buffer.ByteBuf;
import com.datasift.shaded.io.netty.buffer.ByteBufInputStream;
import com.datasift.shaded.io.netty.buffer.Unpooled;
import com.datasift.shaded.io.netty.handler.codec.http.HttpHeaders;
import com.datasift.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import com.datasift.shaded.io.netty.handler.codec.http.HttpVersion;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Reader<T> {
    protected static final Charset utf8 = Charset.forName("UTF-8");
    protected final Logger log = LoggerFactory.getLogger(Reader.class.getName());
    protected ByteBuf buffer = Unpooled.buffer();
    protected ByteBufInputStream data = new ByteBufInputStream(this.buffer);
    protected Set<Function2<T, Response>> functions = new HashSet<Function2<T, Response>>();
    protected Response response;
    private boolean completed;

    public Reader() {
    }

    public Reader(Function2<T, Response> function) {
        if (function == null) {
            throw new IllegalArgumentException("Function cannot be null, use another constructor");
        }
        this.listen(function);
    }

    public void listen(Function2<T, Response> function) {
        if (function != null) {
            this.functions.add(function);
        }
    }

    public void data(ByteBuf data) {
        this.buffer.writeBytes(data);
    }

    public void onStatus(HttpResponseStatus status) {
    }

    public void onProtocolVersion(HttpVersion protocolVersion) {
    }

    public void onHeaders(HttpHeaders headers) {
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
        if (completed) {
            this.done();
        }
    }

    public abstract void done();

    public Response response() {
        return this.response;
    }

    public void response(Response response) {
        this.response = response;
    }
}

