/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.ws.client;

import com.datasift.shaded.io.higgs.http.client.ClientIntializer;
import com.datasift.shaded.io.higgs.http.client.ConnectHandler;
import com.datasift.shaded.io.netty.buffer.ByteBuf;
import com.datasift.shaded.io.netty.channel.ChannelHandler;
import com.datasift.shaded.io.netty.channel.ChannelPipeline;
import com.datasift.shaded.io.netty.channel.SimpleChannelInboundHandler;
import com.datasift.shaded.io.netty.handler.codec.http.HttpClientCodec;
import com.datasift.shaded.io.netty.handler.codec.http.HttpObjectAggregator;
import com.datasift.shaded.io.netty.handler.codec.http.HttpRequest;
import com.datasift.shaded.io.netty.handler.codec.http.HttpRequestEncoder;
import com.datasift.shaded.io.netty.handler.codec.http.HttpResponseDecoder;

public class WebSocketInitializer
extends ClientIntializer {
    protected final int maxContentLength;
    private final String fullUrl;

    public WebSocketInitializer(int maxContentLength, boolean ssl, SimpleChannelInboundHandler<Object> handler, ConnectHandler connHandler, String fullUrl, String[] sslProtocols) {
        super(ssl, handler, connHandler, sslProtocols);
        this.maxContentLength = maxContentLength;
        this.fullUrl = fullUrl;
    }

    @Override
    public void configurePipeline(final ChannelPipeline pipeline) {
        if (this.connectHandler != null) {
            super.configurePipeline(pipeline);
        } else {
            if (this.ssl) {
                WebSocketInitializer.addSSL(pipeline, false, this.sslProtocols);
            }
            if (pipeline.get("codec") != null) {
                pipeline.remove("codec");
            }
            if (pipeline.get("inflater") != null) {
                pipeline.remove("inflater");
            }
            if (pipeline.get("chunkedWriter") != null) {
                pipeline.remove("chunkedWriter");
            }
            if (pipeline.get("handler") != null) {
                pipeline.remove("handler");
            }
            if (this.fullUrl != null) {
                pipeline.addLast("http-decoder", (ChannelHandler)new HttpResponseDecoder());
                pipeline.addLast("http-encoder", (ChannelHandler)new InterceptingEncoder(){

                    @Override
                    protected void encodeInitialLine(ByteBuf buf, HttpRequest request) throws Exception {
                        request.setUri(WebSocketInitializer.this.fullUrl);
                        super.encodeInitialLine(buf, request);
                        pipeline.remove(this);
                        pipeline.addLast("http-encoder", (ChannelHandler)new HttpRequestEncoder());
                    }
                });
            } else {
                pipeline.addLast("http-codec", (ChannelHandler)new HttpClientCodec());
            }
            pipeline.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLength));
            pipeline.addLast("ws-handler", this.handler);
        }
    }

    private static class InterceptingEncoder
    extends HttpRequestEncoder {
        private InterceptingEncoder() {
        }
    }
}

