/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.netty.channel;

import com.datasift.shaded.io.netty.channel.Channel;
import com.datasift.shaded.io.netty.channel.ChannelFuture;
import com.datasift.shaded.io.netty.channel.ChannelPromise;
import com.datasift.shaded.io.netty.channel.EventLoop;
import com.datasift.shaded.io.netty.channel.EventLoopGroup;
import com.datasift.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import com.datasift.shaded.io.netty.util.concurrent.MultithreadEventExecutorGroup;
import com.datasift.shaded.io.netty.util.internal.SystemPropertyUtil;
import com.datasift.shaded.io.netty.util.internal.logging.InternalLogger;
import com.datasift.shaded.io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.ThreadFactory;

public abstract class MultithreadEventLoopGroup
extends MultithreadEventExecutorGroup
implements EventLoopGroup {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MultithreadEventLoopGroup.class);
    private static final int DEFAULT_EVENT_LOOP_THREADS = Math.max(1, SystemPropertyUtil.getInt("com.datasift.shaded.io.netty.eventLoopThreads", Runtime.getRuntime().availableProcessors() * 2));

    protected MultithreadEventLoopGroup(int nThreads, ThreadFactory threadFactory, Object ... args) {
        super(nThreads == 0 ? DEFAULT_EVENT_LOOP_THREADS : nThreads, threadFactory, args);
    }

    @Override
    protected ThreadFactory newDefaultThreadFactory() {
        return new DefaultThreadFactory(this.getClass(), 10);
    }

    @Override
    public EventLoop next() {
        return (EventLoop)super.next();
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return this.next().register(channel);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise promise) {
        return this.next().register(channel, promise);
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.eventLoopThreads: {}", (Object)DEFAULT_EVENT_LOOP_THREADS);
        }
    }
}

