/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.PushConnectors;
import com.datasift.client.push.connectors.Prepared;
import com.datasift.client.push.connectors.PushConnector;
import java.util.Map;
import java.util.Set;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public class BaseConnector<T extends PushConnector<T>>
implements PushConnector<T> {
    protected static final String PREFIX = "output_params.";
    protected final Set<String> required;
    protected final Prepared params;
    private T thisRef;
    private OutputType<T> type;

    public BaseConnector(OutputType<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("A valid type is required");
        }
        this.type = type;
        this.required = new NonBlockingHashSet<String>();
        this.params = new Prepared(this.required);
    }

    public static PushConnector fromMap(OutputType<PushConnector> ptype, Map<String, Object> params) {
        String type = ptype.value();
        if (OutputType.BIG_QUERY.value().equals(type)) {
            return PushConnectors.bigQuery().putAll(params);
        }
        if (OutputType.COUCH_DB.value().equals(type)) {
            return PushConnectors.couchDB().putAll(params);
        }
        if (OutputType.DYNAMO_DB.value().equals(type)) {
            return PushConnectors.dynamoDB().putAll(params);
        }
        if (OutputType.ELASTIC_SEARCH.value().equals(type)) {
            return PushConnectors.elasticSearch().putAll(params);
        }
        if (OutputType.FTP_TYPE.value().equals(type)) {
            return PushConnectors.ftp().putAll(params);
        }
        if (OutputType.HTTP_TYPE.value().equals(type)) {
            return PushConnectors.http().putAll(params);
        }
        if (OutputType.MONGO_DB.value().equals(type)) {
            return PushConnectors.mongoDB().putAll(params);
        }
        if (OutputType.PRECOG.value().equals(type)) {
            return PushConnectors.precog().putAll(params);
        }
        if (OutputType.REDIS.value().equals(type)) {
            return PushConnectors.redis().putAll(params);
        }
        if (OutputType.S3_OUTPUT.value().equals(type)) {
            return PushConnectors.s3().putAll(params);
        }
        if (OutputType.SFTP_OUTPUT.value().equals(type)) {
            return PushConnectors.sftp().putAll(params);
        }
        if (OutputType.SPLUNK_STORM_REST.value().equals(type)) {
            return PushConnectors.splunkStormRest().putAll(params);
        }
        if (OutputType.SPLUNK_ENTERPRISE.value().equals(type)) {
            return PushConnectors.splunkEnterprise().putAll(params);
        }
        if (OutputType.SPLUNK_STORM.value().equals(type)) {
            return PushConnectors.splunkStorm().putAll(params);
        }
        if (OutputType.ZOOM_DATA.value().equals(type)) {
            return PushConnectors.zoomdata().putAll(params);
        }
        return null;
    }

    protected void setup(T ref, String ... requiredParams) {
        this.thisRef = ref;
        if (requiredParams == null) {
            throw new IllegalArgumentException("Set of required params cannot be null");
        }
        for (String param : requiredParams) {
            this.required.add(PREFIX + param);
        }
    }

    protected T setParam(String paramName, String value) {
        if (paramName == null || value == null) {
            throw new IllegalArgumentException(paramName + " is null but no parameters are allowed to be");
        }
        this.params.add(PREFIX + paramName, value);
        return this.thisRef;
    }

    protected boolean exists(String paramName) {
        return this.params.has(PREFIX + paramName);
    }

    @Override
    public Prepared parameters() {
        return this.params;
    }

    @Override
    public OutputType<T> type() {
        return this.type;
    }

    protected T putAll(Map<String, Object> params) {
        if (params != null) {
            for (Map.Entry<String, Object> e : params.entrySet()) {
                if (e.getValue() == null || e.getKey() == null) continue;
                this.setParam(e.getKey(), String.valueOf(e.getValue()));
            }
        }
        return this.thisRef;
    }
}

