/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.core.reflect.dependency;

import com.datasift.shaded.io.higgs.core.reflect.ReflectionUtil;
import com.datasift.shaded.io.higgs.core.reflect.dependency.DependencyProvider;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public class Injector {
    private static NonBlockingHashSet<DependencyProvider> providers = new NonBlockingHashSet();
    private static NonBlockingHashMap<String, DependencyProvider> namedProviders = new NonBlockingHashMap();

    public static void register(DependencyProvider ... providers) {
        for (DependencyProvider o : providers) {
            Injector.providers.add(o);
        }
    }

    public static boolean deRegister(DependencyProvider provider) {
        return provider != null && providers.remove(provider);
    }

    public static boolean register(String name, DependencyProvider provider) {
        return provider != null && namedProviders.put(name, provider) == null;
    }

    public static boolean deRegister(String name) {
        return name != null && namedProviders.remove(name) == null;
    }

    public static Object[] inject(Class<?>[] accepts, Object[] providedParams, DependencyProvider local) {
        Object[] p = new Object[accepts.length];
        if (p.length > 0) {
            int incomingIdx = -1;
            block0: for (int i = 0; i < accepts.length; ++i) {
                Object param;
                Class<?> expectedClass = accepts[i];
                Object object = param = incomingIdx + 1 < providedParams.length ? providedParams[incomingIdx + 1] : null;
                if (param != null) {
                    boolean added = false;
                    if (!ReflectionUtil.isNumeric(expectedClass)) {
                        if (expectedClass.isAssignableFrom(param.getClass())) {
                            p[i] = param;
                            added = true;
                        }
                    } else if (ReflectionUtil.isNumeric(param.getClass())) {
                        added = Injector.assignParam(expectedClass, p, i, param);
                    }
                    if (added) {
                        ++incomingIdx;
                        continue;
                    }
                }
                if (local.has(expectedClass)) {
                    p[i] = param = local.get(expectedClass);
                }
                for (DependencyProvider provider : providers) {
                    if (!provider.has(expectedClass)) continue;
                    p[i] = param = provider.get(expectedClass);
                    continue block0;
                }
            }
        }
        return p;
    }

    private static boolean assignParam(Class<?> expectedClass, Object[] p, int i, Object param) {
        Class<?> paramClass = param.getClass();
        if (!ReflectionUtil.isNumeric(expectedClass)) {
            return false;
        }
        if (Integer.class.isAssignableFrom(paramClass)) {
            p[i] = (Integer)param;
        } else if (Integer.TYPE.isAssignableFrom(expectedClass)) {
            p[i] = (int)((Integer)param);
        } else if (Long.class.isAssignableFrom(expectedClass)) {
            p[i] = (Long)param;
        } else if (Long.TYPE.isAssignableFrom(expectedClass)) {
            p[i] = (long)((Long)param);
        } else if (Double.class.isAssignableFrom(expectedClass)) {
            p[i] = (Double)param;
        } else if (Double.TYPE.isAssignableFrom(expectedClass)) {
            p[i] = (double)((Double)param);
        } else if (Float.class.isAssignableFrom(expectedClass)) {
            p[i] = (Float)param;
        } else if (Float.TYPE.isAssignableFrom(expectedClass)) {
            p[i] = Float.valueOf(((Float)param).floatValue());
        } else if (Short.class.isAssignableFrom(expectedClass)) {
            p[i] = (Short)param;
        } else if (Short.TYPE.isAssignableFrom(expectedClass)) {
            p[i] = (short)((Short)param);
        } else if (Byte.class.isAssignableFrom(expectedClass)) {
            p[i] = (Byte)param;
        } else if (Byte.TYPE.isAssignableFrom(expectedClass)) {
            p[i] = (byte)((Byte)param);
        } else {
            return false;
        }
        return true;
    }

    public static void inject(Object instance, DependencyProvider local) {
        if (instance == null) {
            return;
        }
        Set<Field> fields = ReflectionUtil.getAllFields(new HashSet<Field>(), instance.getClass());
        for (Field field : fields) {
            DependencyProvider provider;
            Object param;
            try {
                field.setAccessible(true);
            }
            catch (SecurityException se) {
                return;
            }
            try {
                if (field.get(instance) != null) {
                    continue;
                }
            }
            catch (IllegalAccessException e) {
                return;
            }
            Class<?> fieldType = field.getType();
            if (local.has(fieldType) && (param = local.get(fieldType)) != null && Injector.setField(instance, field, param)) continue;
            Iterator<DependencyProvider> i$ = providers.iterator();
            while (!(!i$.hasNext() || (provider = i$.next()).has(fieldType) && (param = provider.get(fieldType)) != null && Injector.setField(instance, field, param))) {
            }
        }
    }

    private static boolean setField(Object instance, Field field, Object param) {
        try {
            field.set(instance, param);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public DependencyProvider get(String name) {
        return namedProviders.get(name);
    }
}

