/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.ws.client;

import com.datasift.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.datasift.shaded.io.higgs.core.StaticUtil;
import com.datasift.shaded.io.higgs.core.func.Function1;
import com.datasift.shaded.io.higgs.http.client.ClientIntializer;
import com.datasift.shaded.io.higgs.http.client.ConnectHandler;
import com.datasift.shaded.io.higgs.http.client.FutureResponse;
import com.datasift.shaded.io.higgs.http.client.HttpRequestBuilder;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.PageReader;
import com.datasift.shaded.io.higgs.ws.client.WebSocketClientHandler;
import com.datasift.shaded.io.higgs.ws.client.WebSocketEventListener;
import com.datasift.shaded.io.higgs.ws.client.WebSocketInitializer;
import com.datasift.shaded.io.higgs.ws.client.WebSocketStream;
import com.datasift.shaded.io.netty.bootstrap.Bootstrap;
import com.datasift.shaded.io.netty.channel.ChannelFuture;
import com.datasift.shaded.io.netty.channel.ChannelHandler;
import com.datasift.shaded.io.netty.channel.ChannelHandlerContext;
import com.datasift.shaded.io.netty.channel.SimpleChannelInboundHandler;
import com.datasift.shaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import com.datasift.shaded.io.netty.handler.codec.http.HttpHeaders;
import com.datasift.shaded.io.netty.handler.codec.http.HttpMethod;
import com.datasift.shaded.io.netty.handler.codec.http.HttpVersion;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.cliffc.high_scale_lib.NonBlockingHashSet;

public class WebSocketClient
extends Request {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    protected static final HttpRequestBuilder BUILDER = HttpRequestBuilder.instance();
    public static int maxFramePayloadLength = 655360;
    protected final WebSocketClientHandler handler;
    protected NonBlockingHashSet<WebSocketEventListener> listeners = new NonBlockingHashSet();
    protected WebSocketClientHandshaker handshaker;
    protected boolean allowExtensions;
    protected WebSocketVersion version = WebSocketVersion.V13;
    protected String subprotocol;
    protected HttpHeaders customHeaderSet = new DefaultHttpHeaders();
    protected int maxContentLength = 8192;
    protected WebSocketStream stream;
    protected boolean autoPong = true;
    protected String[] sslProtocols;

    public WebSocketClient(URI uri, Map<String, Object> customHeaders, boolean autoPong, String[] sslProtocols) {
        super(BUILDER, HttpRequestBuilder.group(), uri, HttpMethod.GET, HttpVersion.HTTP_1_1, new PageReader());
        String protocol = uri.getScheme();
        if (!"ws".equals(protocol) && !"wss".equals(protocol)) {
            throw new IllegalArgumentException("Unsupported protocol: " + protocol);
        }
        if (customHeaders != null) {
            for (Map.Entry<String, Object> e : customHeaders.entrySet()) {
                this.customHeaderSet.add(e.getKey(), e.getValue());
            }
        }
        this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(uri, this.version, this.subprotocol, this.allowExtensions, this.customHeaderSet, maxFramePayloadLength);
        this.handler = new WebSocketClientHandler(this.handshaker, this.listeners, autoPong);
        this.autoPong = autoPong;
        this.sslProtocols = sslProtocols == null || sslProtocols.length == 0 ? HttpRequestBuilder.getSupportedSSLProtocols() : sslProtocols;
    }

    public static WebSocketStream connect(URI uri, boolean autoPong, String[] sslProtocols) {
        return WebSocketClient.connect(uri, autoPong, sslProtocols, null);
    }

    public static WebSocketStream connect(URI uri, boolean autoPong, String[] sslProtocols, Function1<Bootstrap> conf) {
        return WebSocketClient.connect(uri, new HashMap<String, Object>(), autoPong, sslProtocols, conf);
    }

    public static WebSocketStream connect(URI uri, Map<String, Object> customHeaders, boolean autoPong, String[] sslProtocols, Function1<Bootstrap> conf) {
        WebSocketClient client = new WebSocketClient(uri, customHeaders, autoPong, sslProtocols);
        client.execute((Function1)conf);
        return client.stream();
    }

    @Override
    public FutureResponse execute() {
        return this.execute((Function1)null);
    }

    public FutureResponse execute(Function1 conf) {
        FutureResponse res = super.execute(conf);
        this.stream = new WebSocketStream(this.uri, this.connectFuture, this.listeners);
        return res;
    }

    public WebSocketStream stream() {
        return this.stream;
    }

    @Override
    protected String getScheme() {
        return this.uri.getScheme() == null ? "ws" : this.uri.getScheme();
    }

    @Override
    protected String getHost() {
        return this.uri.getHost() == null ? "localhost" : this.uri.getHost();
    }

    @Override
    protected boolean isSSLScheme(String scheme) {
        return "wss".equalsIgnoreCase(scheme);
    }

    @Override
    protected ChannelHandler newInitializer() {
        final String fullUrl = this.isProxyEnabled() && !this.tunneling ? this.request.getUri() : null;
        ConnectHandler.InitFactory factory = new ConnectHandler.InitFactory(){

            @Override
            public ClientIntializer newInstance(boolean ssl, SimpleChannelInboundHandler<Object> handler, ConnectHandler h) {
                return new WebSocketInitializer(WebSocketClient.this.maxContentLength, ssl, handler, h, fullUrl, WebSocketClient.this.sslProtocols);
            }
        };
        final WebSocketClientHandler wsh = this.handler;
        ConnectHandler connectHandler = new ConnectHandler(this.tunneling, this.request, this.handler, factory){

            @Override
            protected void writeOriginalRequest(ChannelHandlerContext ctx) {
                wsh.doHandshake(ctx);
            }
        };
        connectHandler = this.isProxyEnabled() && this.proxyRequest != null ? connectHandler : null;
        return new WebSocketInitializer(this.maxContentLength, this.useSSL, this.handler, connectHandler, fullUrl, this.sslProtocols);
    }

    @Override
    protected ChannelFuture makeTheRequest() {
        if (this.isProxyEnabled() && this.proxyRequest != null) {
            return StaticUtil.write(this.channel, (Object)this.proxyRequest);
        }
        return null;
    }

    @Override
    protected SimpleChannelInboundHandler<Object> newHandler() {
        return this.handler;
    }
}

