/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.push.OutputType;
import com.datasift.client.push.Status;
import com.datasift.client.push.connectors.BaseConnector;
import com.datasift.client.push.connectors.PushConnector;
import com.datasift.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class PushSubscription
extends BaseDataSiftResult {
    @JsonProperty
    private String id;
    @JsonProperty(value="output_type")
    private String outputType;
    @JsonProperty
    private String name;
    @JsonProperty(value="created_at")
    private long createdAt;
    @JsonProperty(value="user_id")
    private String userId;
    @JsonProperty(value="hash")
    private String hash;
    @JsonProperty(value="hash_type")
    private String hashType;
    @JsonProperty(value="output_params")
    private Map<String, Object> outputParams;
    @JsonProperty
    private Status status;
    @JsonProperty(value="last_request")
    private long lastRequest;
    @JsonProperty(value="last_success")
    private long lastSuccess;
    @JsonProperty(value="remaining_bytes")
    private long remainingBytes;
    @JsonProperty
    private boolean lostData;
    @JsonProperty
    private long start;
    @JsonProperty
    private long end;

    public String getId() {
        return this.id;
    }

    public <T extends PushConnector> OutputType<T> getOutputType() {
        return OutputType.fromString(this.outputType);
    }

    public String name() {
        return this.name;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String getUserId() {
        return this.userId;
    }

    public String hash() {
        return this.hash;
    }

    public String getHashType() {
        return this.hashType;
    }

    public PushConnector getOutputParams() {
        return BaseConnector.fromMap(this.getOutputType(), this.outputParams);
    }

    public Status status() {
        return this.status;
    }

    public long getLastRequest() {
        return this.lastRequest;
    }

    public long getLastSuccess() {
        return this.lastSuccess;
    }

    public long getRemainingBytes() {
        return this.remainingBytes;
    }

    public boolean isLostData() {
        return this.lostData;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public static PushSubscription fromString(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a stream from an empty or null string");
        }
        PushSubscription stream = new PushSubscription();
        stream.id = str;
        return stream;
    }
}

