/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.pylon;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.ParamBuilder;
import com.datasift.client.pylon.PylonQuery;
import com.datasift.client.pylon.PylonRecording;
import com.datasift.client.pylon.PylonRecordingList;
import com.datasift.client.pylon.PylonResult;
import com.datasift.client.pylon.PylonSample;
import com.datasift.client.pylon.PylonSampleRequest;
import com.datasift.client.pylon.PylonStream;
import com.datasift.client.pylon.PylonTags;
import com.datasift.client.pylon.PylonValidation;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.io.higgs.http.client.JSONRequest;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.PageReader;
import java.net.URI;

public class DataSiftPylon
extends DataSiftApiClient {
    public final String VALIDATE = "pylon/validate";
    public final String COMPILE = "pylon/compile";
    public final String START = "pylon/start";
    public final String STOP = "pylon/stop";
    public final String UPDATE = "pylon/update";
    public final String GET = "pylon/get";
    public final String ANALYZE = "pylon/analyze";
    public final String TAGS = "pylon/tags";
    public final String SAMPLE = "pylon/sample";

    public DataSiftPylon(DataSiftConfig config) {
        super(config);
    }

    public FutureData<PylonValidation> validate(String csdl) {
        FutureData<PylonValidation> future = new FutureData<PylonValidation>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/validate"));
        JSONRequest request = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new PylonValidation(), this.config))).addField("csdl", csdl);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonStream> compile(String csdl) {
        FutureData<PylonStream> future = new FutureData<PylonStream>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/compile"));
        JSONRequest request = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new PylonStream(), this.config))).addField("csdl", csdl);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonRecording.PylonRecordingId> start(PylonStream stream) {
        return this.start(stream, null);
    }

    public FutureData<PylonRecording.PylonRecordingId> start(PylonStream stream, String name) {
        if (stream == null || stream.hash.isEmpty()) {
            throw new IllegalArgumentException("A valid hash is required to start a stream");
        }
        FutureData<PylonRecording.PylonRecordingId> future = new FutureData<PylonRecording.PylonRecordingId>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/start"));
        JSONRequest request = this.config.http().putJSON(uri, new PageReader(this.newRequestCallback(future, new PylonRecording.PylonRecordingId(), this.config))).addField("hash", stream.hash).addField("name", name);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> restart(PylonRecording.PylonRecordingId recordingId) {
        if (recordingId == null || recordingId.id == null || recordingId.id.isEmpty()) {
            throw new IllegalArgumentException("A valid recording id is required to restart a recording");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/start"));
        JSONRequest request = this.config.http().putJSON(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).addField("id", recordingId.getId());
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> update(PylonRecording.PylonRecordingId recordingId, String newName) {
        return this.update(recordingId, null, newName);
    }

    public FutureData<DataSiftResult> update(PylonRecording.PylonRecordingId recordingId, PylonStream stream) {
        return this.update(recordingId, stream, null);
    }

    public FutureData<DataSiftResult> update(PylonRecording.PylonRecordingId recordingId, PylonStream stream, String newName) {
        if (recordingId == null || recordingId.id == null || recordingId.id.isEmpty()) {
            throw new IllegalArgumentException("A valid recording id is required to update a recording");
        }
        if ((stream == null || stream.hash == null || stream.hash.isEmpty()) && newName == null) {
            throw new IllegalArgumentException("One of stream or newName must be supplied for an update");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/update"));
        JSONRequest request = this.config.http().putJSON(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).addField("id", recordingId.id);
        if (stream != null) {
            request.addField("hash", stream.hash);
        }
        if (newName != null) {
            request.addField("name", newName);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> stop(PylonRecording.PylonRecordingId recordingId) {
        if (recordingId == null || recordingId.getId() == null || recordingId.getId().isEmpty()) {
            throw new IllegalArgumentException("A valid recording id is required to stop a recording");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/stop"));
        JSONRequest request = this.config.http().putJSON(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).addField("id", recordingId.getId());
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonRecordingList> get() {
        return this.get(0, 0);
    }

    public FutureData<PylonRecordingList> get(int page) {
        return this.get(page, 0);
    }

    public FutureData<PylonRecordingList> get(int page, int perPage) {
        FutureData<PylonRecordingList> future = new FutureData<PylonRecordingList>();
        ParamBuilder b = new ParamBuilder();
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI("pylon/get"));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new PylonRecordingList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonRecording> get(PylonRecording.PylonRecordingId recordingId) {
        URI uri = this.newParams().put("id", recordingId.id).forURL(this.config.newAPIEndpointURI("pylon/get"));
        FutureData<PylonRecording> future = new FutureData<PylonRecording>();
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new PylonRecording(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonResult> analyze(PylonQuery query) {
        if (query == null) {
            throw new IllegalArgumentException("A valid analyze request body is required to analyze a stream");
        }
        FutureData<PylonResult> future = new FutureData<PylonResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/analyze"));
        try {
            JSONRequest result = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new PylonResult(), this.config))).setData(query);
            this.performRequest(future, result);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Valid JSON is required to analyze a stream");
        }
        return future;
    }

    public FutureData<PylonTags> tags(PylonRecording.PylonRecordingId recordingId) {
        URI uri = this.newParams().put("id", recordingId.id).forURL(this.config.newAPIEndpointURI("pylon/tags"));
        FutureData<PylonTags> future = new FutureData<PylonTags>();
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new PylonTags(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PylonSample> sample(PylonSampleRequest sampleRequest) {
        if (sampleRequest == null || sampleRequest.recordingId == null) {
            throw new IllegalArgumentException("A valid sample request object containing a recordingId is required to carry out a Pylon sample");
        }
        FutureData<PylonSample> future = new FutureData<PylonSample>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pylon/sample"));
        try {
            JSONRequest result = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new PylonSample(), this.config))).setData(sampleRequest);
            this.performRequest(future, result);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Valid JSON is required to analyze a stream");
        }
        return future;
    }
}

