/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.stream;

import com.datasift.client.core.Stream;
import com.datasift.client.stream.MultiStreamInteraction;
import com.datasift.shaded.org.cliffc.high_scale_lib.NonBlockingHashSet;
import java.util.Set;

public class DataSiftMessage {
    protected long tick;
    protected String status;
    protected String message;
    protected Set<Stream> hashes = new NonBlockingHashSet<Stream>();

    public DataSiftMessage(MultiStreamInteraction mi) {
        this.tick = mi.getTick();
        this.status = mi.getStatus();
        this.message = mi.getMessage();
        if (mi.hasHashes()) {
            for (String string : mi.hashes()) {
                this.hashes.add(Stream.fromString(string));
            }
        }
    }

    public boolean isInfo() {
        return !this.isError() && !this.isWarning();
    }

    public boolean isWarning() {
        return "warning".equals(this.status);
    }

    public boolean isError() {
        return "failure".equals(this.status);
    }

    public long getTick() {
        return this.tick;
    }

    public String getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "DataSiftMessage{tick=" + this.tick + ", status='" + this.status + '\'' + ", message='" + this.message + '\'' + '}';
    }

    public boolean hashHashes() {
        return this.hashes.size() > 0;
    }

    public Set<Stream> hashes() {
        return this.hashes;
    }
}

