/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.core.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class ReflectionUtil {
    public static int MAX_RECURSION_DEPTH = 10;

    private ReflectionUtil() {
    }

    public static Set<Field> getAllFields(Set<Field> fields, Class<?> type) {
        return ReflectionUtil.getAllFields(fields, type, 0);
    }

    public static Set<Field> getAllFields(Set<Field> fields, Class<?> type, int depth) {
        if (type.getSuperclass() != null && depth <= MAX_RECURSION_DEPTH) {
            ReflectionUtil.getAllFields(fields, type.getSuperclass(), ++depth);
        }
        Collections.addAll(fields, type.getDeclaredFields());
        return fields;
    }

    public static Method[] getAllMethods(Class<?> klass) {
        HashSet<Method> methods = new HashSet<Method>();
        ReflectionUtil.getAllMethods(methods, klass);
        return methods.toArray(new Method[methods.size()]);
    }

    public static Set<Method> getAllMethods(Set<Method> methods, Class<?> type) {
        return ReflectionUtil.getAllMethods(methods, type, 0);
    }

    public static Set<Method> getAllMethods(Set<Method> methods, Class<?> type, int depth) {
        if (type.getSuperclass() != null && depth <= MAX_RECURSION_DEPTH) {
            ReflectionUtil.getAllMethods(methods, type.getSuperclass(), ++depth);
        }
        Collections.addAll(methods, type.getDeclaredMethods());
        return methods;
    }

    public static boolean isNumeric(Class<?> klass) {
        return Integer.class.isAssignableFrom(klass) || Integer.TYPE.isAssignableFrom(klass) || Long.class.isAssignableFrom(klass) || Long.TYPE.isAssignableFrom(klass) || Double.class.isAssignableFrom(klass) || Double.TYPE.isAssignableFrom(klass) || Float.class.isAssignableFrom(klass) || Float.TYPE.isAssignableFrom(klass) || Short.class.isAssignableFrom(klass) || Short.class.isAssignableFrom(klass) || Byte.class.isAssignableFrom(klass) || Byte.TYPE.isAssignableFrom(klass);
    }
}

