/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.DataSiftClient;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Response {
    protected String data;
    protected com.datasift.shaded.io.higgs.http.client.Response rawResponse;
    protected boolean failed;
    protected Throwable cause;
    private Map<String, List<String>> headers = new HashMap<String, List<String>>();

    public Response(String data, com.datasift.shaded.io.higgs.http.client.Response rawResponse) {
        this.data = data;
        this.rawResponse = rawResponse;
        if (rawResponse.getHeaders() != null) {
            for (String name : rawResponse.getHeaders().names()) {
                this.headers.put(name, rawResponse.getHeaders().getAll(name));
            }
        }
        if (rawResponse.hasFailed()) {
            this.failed = true;
            this.cause = rawResponse.failureCause();
        }
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public Throwable failureCause() {
        return this.cause;
    }

    public int status() {
        return this.rawResponse.getStatus().code();
    }

    public String statusMessage() {
        return this.rawResponse.getStatus().reasonPhrase();
    }

    public float protocolVersion() {
        return Float.parseFloat(this.rawResponse.getProtocolVersion().majorVersion() + "." + this.rawResponse.getProtocolVersion().minorVersion());
    }

    public boolean isChunked() {
        return this.rawResponse.isChunked();
    }

    public String data() {
        return this.data;
    }

    public Map<String, List<String>> headers() {
        return this.headers;
    }

    public String toString() {
        try {
            return DataSiftClient.MAPPER.writeValueAsString(this.rawResponse);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "Unable to generate string representation of this response/result";
        }
    }
}

