/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.managedsource.sources.BaseSource;
import com.datasift.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.datasift.shaded.org.cliffc.high_scale_lib.NonBlockingHashMap;
import com.datasift.shaded.org.cliffc.high_scale_lib.NonBlockingHashSet;
import com.datasift.shaded.org.joda.time.DateTime;
import java.util.Map;
import java.util.Set;

public class ManagedSource
extends BaseDataSiftResult {
    @JsonProperty
    protected String name;
    @JsonProperty(value="source_type")
    protected String sourceType;
    @JsonProperty
    protected Map<String, Object> parameters = new NonBlockingHashMap<String, Object>();
    @JsonProperty
    protected Set<ResourceParams> resources = new NonBlockingHashSet<ResourceParams>();
    @JsonProperty
    protected Set<AuthParams> auth = new NonBlockingHashSet<AuthParams>();
    @JsonProperty(value="created_at")
    protected long createdAt;
    @JsonProperty
    protected String id;
    @JsonProperty
    protected String status;

    public static ManagedSource fromString(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a managed source from an empty or null string");
        }
        ManagedSource stream = new ManagedSource();
        stream.id = str;
        return stream;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public Set<ResourceParams> getResources() {
        return this.resources;
    }

    public Set<AuthParams> getAuth() {
        return this.auth;
    }

    public DateTime getCreatedAt() {
        return new DateTime(this.createdAt);
    }

    public String getId() {
        return this.id;
    }

    public String getStatus() {
        return this.status;
    }

    public static class ResourceParams
    extends BaseSource.ResourceParams {
        @JsonProperty(value="identity_id")
        protected String identityId;
        @JsonProperty(value="source_id")
        protected String sourceId;
        @JsonProperty
        protected String status;

        protected ResourceParams() {
        }

        public String identityId() {
            return this.identityId;
        }

        public String sourceId() {
            return this.sourceId;
        }

        public String status() {
            return this.status;
        }
    }

    public static class AuthParams
    extends BaseSource.AuthParams {
        @JsonProperty(value="identity_id")
        protected String identityId;
        @JsonProperty(value="source_id")
        protected String sourceId;
        @JsonProperty
        protected String status;

        protected AuthParams() {
        }

        public String identityId() {
            return this.identityId;
        }

        public String sourceId() {
            return this.sourceId;
        }

        public String status() {
            return this.status;
        }
    }
}

