/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.stream;

import com.datasift.client.DataSiftConfig;
import com.datasift.client.core.Stream;
import com.datasift.client.stream.DataSiftConnection;
import com.datasift.client.stream.ErrorListener;
import com.datasift.client.stream.StreamEventListener;
import com.datasift.client.stream.StreamSubscription;
import com.datasift.shaded.io.higgs.ws.client.WebSocketClient;
import com.datasift.shaded.org.cliffc.high_scale_lib.NonBlockingHashSet;
import com.datasift.shaded.org.joda.time.DateTime;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionManager {
    protected URI endpoint;
    protected DataSiftConfig config;
    protected ErrorListener errorListener;
    protected StreamEventListener streamEventListener;
    protected boolean connected;
    public static boolean detectDeadConnection = true;
    public static int CONNECTION_TIMEOUT_LIMIT = 65;
    public static int CONNECTION_TIMEOUT = 65;
    protected static boolean CONNECTION_DETECTOR_RUNNING;
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    public static final Set<DataSiftConnection> connections;
    protected final int MAX_STREAMS_PER_CONNECTION = 200;

    public static void detectDeadConnections() {
        if (CONNECTION_DETECTOR_RUNNING) {
            return;
        }
        final Logger log = LoggerFactory.getLogger(ConnectionManager.class);
        Thread deadConnThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CONNECTION_DETECTOR_RUNNING = true;
                try {
                    log.debug("Starting dead connection detection thread");
                    while (detectDeadConnection) {
                        log.debug("Checking if there are any dead connections");
                        long now = DateTime.now().getMillis();
                        for (DataSiftConnection data : connections) {
                            if (data.lastSeen() == null || now - data.lastSeen().getMillis() < TimeUnit.SECONDS.toMillis(CONNECTION_TIMEOUT_LIMIT)) continue;
                            log.info("Dead connection found, triggering re-connection");
                            data.closeAndReconnect();
                        }
                        log.debug(String.format("Checked %s connections", connections.size()));
                        try {
                            Thread.sleep(TimeUnit.SECONDS.toMillis(CONNECTION_TIMEOUT));
                        }
                        catch (InterruptedException e) {
                            LoggerFactory.getLogger(this.getClass()).info("Interrupted while waiting to check conn");
                        }
                    }
                }
                finally {
                    CONNECTION_DETECTOR_RUNNING = false;
                }
            }
        }, "dead-connections-monitor");
        deadConnThread.setDaemon(true);
        deadConnThread.start();
    }

    public ConnectionManager(DataSiftConfig config) {
        try {
            this.endpoint = new URI(String.format("%s://%s:%s/multi?username=%s&api_key=%s", config.isSslEnabled() ? "wss" : "ws", config.wsHost(), config.port(), config.getUsername(), config.getApiKey()));
        }
        catch (URISyntaxException e) {
            this.log.error("Unable to create endpoint URL", (Throwable)e);
        }
        this.config = config;
    }

    protected DataSiftConnection obtainConnectionFor(Stream stream) {
        for (DataSiftConnection conn : connections) {
            if (!conn.isFor(stream)) continue;
            return conn;
        }
        return null;
    }

    public ConnectionManager onError(ErrorListener listener) {
        this.errorListener = listener;
        for (DataSiftConnection conn : connections) {
            conn.setErrorListener(listener);
        }
        return this;
    }

    public void onStreamEvent(StreamEventListener streamEventListener) {
        this.streamEventListener = streamEventListener;
        for (DataSiftConnection conn : connections) {
            conn.setStreamEventListener(streamEventListener);
        }
    }

    public ConnectionManager subscribe(StreamSubscription subscription) {
        if (this.errorListener == null) {
            throw new IllegalStateException("You must call listen before subscribing to streams otherwise you'll miss any exceptions that may occur");
        }
        if (this.streamEventListener == null) {
            throw new IllegalStateException("You must call onStreamEvent before subscribing to streams otherwise you'll miss delete messages, which you are required to handle");
        }
        DataSiftConnection connection = null;
        for (DataSiftConnection conn : connections) {
            if (!conn.canTakeSubscription()) continue;
            connection = conn;
            break;
        }
        if (connection == null) {
            connection = new DataSiftConnection(200, this.config, this.endpoint, this.errorListener, this.streamEventListener);
            connections.add(connection);
        }
        connection.subscribe(subscription);
        return this;
    }

    public ConnectionManager unsubscribe(Stream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("Stream can't be null");
        }
        if (stream.hash() == null || stream.hash().isEmpty()) {
            throw new IllegalArgumentException("Invalid stream subscription request, no hash available");
        }
        DataSiftConnection connection = this.obtainConnectionFor(stream);
        if (connection != null) {
            connection.unsubscribe(stream);
        }
        return this;
    }

    static {
        connections = new NonBlockingHashSet<DataSiftConnection>();
        WebSocketClient.maxFramePayloadLength = 0x1400000;
        ConnectionManager.detectDeadConnections();
    }
}

