/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.com.fasterxml.jackson.databind.deser.std;

import com.datasift.shaded.com.fasterxml.jackson.core.JsonParser;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonToken;
import com.datasift.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.datasift.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.datasift.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import com.datasift.shaded.com.fasterxml.jackson.databind.JavaType;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.datasift.shaded.com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import java.io.IOException;
import java.util.EnumMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMapDeserializer
extends StdDeserializer<EnumMap<?, ?>>
implements ContextualDeserializer {
    protected final JavaType _mapType;
    protected final Class<?> _enumClass;
    protected JsonDeserializer<Enum<?>> _keyDeserializer;
    protected JsonDeserializer<Object> _valueDeserializer;

    public EnumMapDeserializer(JavaType mapType, JsonDeserializer<?> keyDeserializer, JsonDeserializer<?> valueDeser) {
        super(EnumMap.class);
        this._mapType = mapType;
        this._enumClass = mapType.getKeyType().getRawClass();
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = valueDeser;
    }

    public EnumMapDeserializer withResolved(JsonDeserializer<?> keyDeserializer, JsonDeserializer<?> valueDeserializer) {
        if (keyDeserializer == this._keyDeserializer && valueDeserializer == this._valueDeserializer) {
            return this;
        }
        return new EnumMapDeserializer(this._mapType, keyDeserializer, valueDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JsonDeserializer<Object> vd;
        JsonDeserializer<Object> kd = this._keyDeserializer;
        if (kd == null) {
            kd = ctxt.findContextualValueDeserializer(this._mapType.getKeyType(), property);
        }
        if ((vd = this._valueDeserializer) == null) {
            vd = ctxt.findContextualValueDeserializer(this._mapType.getContentType(), property);
        } else if (vd instanceof ContextualDeserializer) {
            vd = ((ContextualDeserializer)((Object)vd)).createContextual(ctxt, property);
        }
        return this.withResolved(kd, vd);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public EnumMap<?, ?> deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        if (jp.getCurrentToken() != JsonToken.START_OBJECT) {
            throw ctxt.mappingException(EnumMap.class);
        }
        EnumMap<?, ?> result = this.constructMap();
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            Enum<?> key = this._keyDeserializer.deserialize(jp, ctxt);
            if (key == null) {
                if (!ctxt.isEnabled(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL)) {
                    String value = null;
                    try {
                        if (jp.hasCurrentToken()) {
                            value = jp.getText();
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    throw ctxt.weirdStringException(value, this._enumClass, "value not one of declared Enum instance names");
                }
                jp.nextToken();
                jp.skipChildren();
                continue;
            }
            JsonToken t = jp.nextToken();
            Object value = t == JsonToken.VALUE_NULL ? null : this._valueDeserializer.deserialize(jp, ctxt);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Object deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException, JsonProcessingException {
        return typeDeserializer.deserializeTypedFromObject(jp, ctxt);
    }

    private EnumMap<?, ?> constructMap() {
        return new EnumMap(this._enumClass);
    }
}

