/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.com.fasterxml.jackson.datatype.joda.deser;

import com.datasift.shaded.com.fasterxml.jackson.core.JsonParser;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonToken;
import com.datasift.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import com.datasift.shaded.com.fasterxml.jackson.datatype.joda.deser.JodaDeserializerBase;
import com.datasift.shaded.org.joda.time.DateTime;
import com.datasift.shaded.org.joda.time.DateTimeZone;
import com.datasift.shaded.org.joda.time.ReadableDateTime;
import com.datasift.shaded.org.joda.time.ReadableInstant;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTimeDeserializer
extends JodaDeserializerBase<ReadableInstant> {
    public DateTimeDeserializer(Class<? extends ReadableInstant> cls) {
        super(cls);
    }

    public static <T extends ReadableInstant> JsonDeserializer<T> forType(Class<T> cls) {
        return new DateTimeDeserializer((Class<? extends ReadableInstant>)cls);
    }

    @Override
    public ReadableDateTime deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonToken t = jp.getCurrentToken();
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return new DateTime(jp.getLongValue(), DateTimeZone.UTC);
        }
        if (t == JsonToken.VALUE_STRING) {
            String str = jp.getText().trim();
            if (str.length() == 0) {
                return null;
            }
            return new DateTime((Object)str, DateTimeZone.UTC);
        }
        throw ctxt.mappingException(this.getValueClass());
    }
}

