/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.core.reflect.dependency;

import com.datasift.shaded.io.higgs.core.reflect.dependency.Injector;
import com.datasift.shaded.org.cliffc.high_scale_lib.NonBlockingHashMap;
import java.util.ArrayList;
import java.util.Map;

public class DependencyProvider {
    private static final DependencyProvider global = new DependencyProvider();
    private NonBlockingHashMap<Class<?>, Object> instances = new NonBlockingHashMap();
    private NonBlockingHashMap<String, Object> named = new NonBlockingHashMap();

    public static DependencyProvider global() {
        return global;
    }

    public static DependencyProvider from(Object ... objs) {
        DependencyProvider provider = new DependencyProvider();
        for (Object o : objs) {
            provider.add(o);
        }
        return provider;
    }

    public boolean add(Object ... dependency) {
        if (dependency == null) {
            return false;
        }
        for (Object o : dependency) {
            if (o == null) continue;
            this.instances.put(o.getClass(), o);
        }
        return true;
    }

    public boolean put(String name, Object value) {
        if (name == null || name.isEmpty() || value == null) {
            return false;
        }
        this.named.put(name, value);
        return true;
    }

    public boolean remove(String name) {
        return name != null && this.named.remove(name) != null;
    }

    public boolean remove(Object i) {
        if (i == null) {
            return false;
        }
        ArrayList entries = new ArrayList();
        for (Map.Entry<Class<Object>, Object> e : this.instances.entrySet()) {
            if (e.getValue() != i) continue;
            entries.add(e);
        }
        for (Map.Entry<Class<Object>, Object> e : entries) {
            this.instances.remove(e.getKey());
        }
        return entries.size() > 0;
    }

    public boolean remove(Class<?> key) {
        return key != null && this.instances.remove(key) != null;
    }

    public void removeAll() {
        this.instances.clear();
        this.named.clear();
    }

    public void removeAllNamed() {
        this.named.clear();
    }

    public void removeAllUnnamed() {
        this.instances.clear();
    }

    public boolean has(Class<?> klass) {
        for (Map.Entry<Class<?>, Object> entry : this.instances.entrySet()) {
            if (!klass.isAssignableFrom(entry.getKey())) continue;
            return true;
        }
        for (Map.Entry<Object, Object> entry : this.named.entrySet()) {
            Object val = entry.getValue();
            if (val == null || !klass.isAssignableFrom(val.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean has(String name) {
        return this.named.containsKey(name);
    }

    public <T> T get(String name) {
        try {
            return (T)this.named.get(name);
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    public Object get(Class<?> klass) {
        for (Map.Entry<Class<?>, Object> entry : this.instances.entrySet()) {
            if (!klass.isAssignableFrom(entry.getKey())) continue;
            return entry.getValue();
        }
        for (Map.Entry<Object, Object> entry : this.named.entrySet()) {
            Object val = entry.getValue();
            if (val == null || !klass.isAssignableFrom(val.getClass())) continue;
            return val;
        }
        return null;
    }

    public void take(DependencyProvider provider) {
        if (provider != null) {
            this.instances.putAll((Map<Class<?>, Object>)provider.instances);
            this.named.putAll((Map<String, Object>)provider.named);
        }
    }

    static {
        Injector.register(global);
    }
}

