/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.core.ssl;

import com.datasift.shaded.io.higgs.core.ssl.SSLConfigFactory;
import com.datasift.shaded.io.higgs.core.ssl.SSLConfiguration;
import com.datasift.shaded.io.netty.channel.ChannelHandler;
import com.datasift.shaded.io.netty.channel.ChannelPipeline;
import com.datasift.shaded.io.netty.handler.ssl.SslHandler;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManagerFactory;

public class SSLContextFactory {
    public SSLContext getSSLSocket(SSLConfiguration sslConfiguration) {
        boolean useTrustStore = false;
        TrustManagerFactory tmf = null;
        try {
            KeyStore trustStore = KeyStore.getInstance(sslConfiguration.getTrustStoreType());
            if (sslConfiguration.getTrustStorePath() != null) {
                trustStore.load(new FileInputStream(sslConfiguration.getTrustStorePath()), sslConfiguration.getTrustStorePassword() == null ? "".toCharArray() : sslConfiguration.getTrustStorePassword().toCharArray());
                tmf = TrustManagerFactory.getInstance(sslConfiguration.getTrustManagerFactoryType());
                tmf.init(trustStore);
                useTrustStore = true;
            } else {
                useTrustStore = false;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to create TrustStore Manager. Reason: " + e.getMessage());
        }
        boolean useClientKeyStore = false;
        KeyManagerFactory kmf = null;
        try {
            KeyStore clientKeyStore = KeyStore.getInstance(sslConfiguration.getKeyStoreType());
            if (sslConfiguration.getKeyStorePath() != null) {
                clientKeyStore.load(new FileInputStream(sslConfiguration.getKeyStorePath()), sslConfiguration.getKeyStorePassword() == null ? "".toCharArray() : sslConfiguration.getKeyStorePassword().toCharArray());
                kmf = KeyManagerFactory.getInstance(sslConfiguration.getKeyManagerFactoryType());
                kmf.init(clientKeyStore, sslConfiguration.getKeyPassword() == null ? "".toCharArray() : sslConfiguration.getKeyPassword().toCharArray());
                useClientKeyStore = true;
            } else {
                useClientKeyStore = false;
            }
        }
        catch (Exception e) {
            System.out.println("Unable to create KeyStore Manager. Reason: " + e.getMessage());
        }
        try {
            SSLContext ctx = SSLContext.getInstance(sslConfiguration.getSecurityProtocol());
            ctx.init(useClientKeyStore ? kmf.getKeyManagers() : null, useTrustStore ? tmf.getTrustManagers() : null, new SecureRandom());
            return ctx;
        }
        catch (Exception e) {
            System.out.println("Unable to create SSL Context. Reason : " + e.getMessage());
            return null;
        }
    }

    public void addSSL(ChannelPipeline pipeline, boolean forceToFront, String[] sslProtocols) {
        SSLEngine engine = this.getSSLSocket(SSLConfigFactory.sslConfiguration).createSSLEngine();
        engine.setUseClientMode(true);
        if (sslProtocols != null && sslProtocols.length > 0) {
            engine.setEnabledProtocols(sslProtocols);
        }
        if (forceToFront) {
            pipeline.addFirst("ssl", (ChannelHandler)new SslHandler(engine));
        } else {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
    }
}

