/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client;

import com.datasift.shaded.io.higgs.core.ssl.SSLContextFactory;
import com.datasift.shaded.io.higgs.http.client.ConnectHandler;
import com.datasift.shaded.io.netty.channel.ChannelHandler;
import com.datasift.shaded.io.netty.channel.ChannelInitializer;
import com.datasift.shaded.io.netty.channel.ChannelPipeline;
import com.datasift.shaded.io.netty.channel.socket.SocketChannel;
import com.datasift.shaded.io.netty.handler.codec.http.HttpClientCodec;
import com.datasift.shaded.io.netty.handler.codec.http.HttpContentDecompressor;
import com.datasift.shaded.io.netty.handler.stream.ChunkedWriteHandler;

public class ClientIntializer
extends ChannelInitializer<SocketChannel> {
    protected final boolean ssl;
    protected final ConnectHandler connectHandler;
    protected final ChannelHandler handler;
    protected final String[] sslProtocols;
    protected final SSLContextFactory sslCtx = new SSLContextFactory();

    public ClientIntializer(boolean ssl, ChannelHandler handler, ConnectHandler connectHandler, String[] sslProtocols) {
        this.ssl = ssl;
        this.handler = handler;
        this.connectHandler = connectHandler;
        this.sslProtocols = sslProtocols;
    }

    @Override
    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        this.configurePipeline(pipeline);
    }

    public void configurePipeline(ChannelPipeline pipeline) {
        if (this.ssl) {
            this.sslCtx.addSSL(pipeline, false, this.sslProtocols);
        }
        if (pipeline.get("codec") == null) {
            pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec());
        } else {
            pipeline.replace("codec", "codec", (ChannelHandler)new HttpClientCodec());
        }
        if (pipeline.get("inflater") == null) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor());
        } else {
            pipeline.replace("inflater", "inflater", (ChannelHandler)new HttpContentDecompressor());
        }
        if (pipeline.get("chunkedWriter") == null) {
            pipeline.addLast("chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        } else {
            pipeline.replace("chunkedWriter", "chunkedWriter", (ChannelHandler)new ChunkedWriteHandler());
        }
        if (pipeline.get("handler") == null) {
            pipeline.addLast("handler", this.connectHandler == null ? this.handler : this.connectHandler);
        } else {
            pipeline.replace("handler", "handler", this.connectHandler == null ? this.handler : this.connectHandler);
        }
    }
}

