/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.ws.client;

import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.io.higgs.ws.client.WebSocketClient;
import com.datasift.shaded.io.higgs.ws.client.WebSocketEventListener;
import com.datasift.shaded.io.netty.channel.Channel;
import com.datasift.shaded.io.netty.channel.ChannelFuture;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.datasift.shaded.io.netty.util.concurrent.Future;
import com.datasift.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.Set;

public class WebSocketStream {
    protected final ChannelFuture future;
    protected final URI uri;
    protected final Set<WebSocketEventListener> listeners;
    protected Channel channel;

    public WebSocketStream(URI uri, ChannelFuture cf, Set<WebSocketEventListener> listeners) {
        this.uri = uri;
        this.future = cf;
        this.listeners = listeners;
        cf.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    WebSocketStream.this.channel = future.channel();
                }
            }
        });
    }

    public WebSocketStream subscribe(WebSocketEventListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public ChannelFuture send(String message) {
        if (this.channel == null || !this.channel.isActive()) {
            throw new IllegalStateException("Not connected");
        }
        return this.channel.writeAndFlush(new TextWebSocketFrame(message));
    }

    public ChannelFuture send(Object message) {
        if (this.channel == null || !this.channel.isActive()) {
            throw new IllegalStateException("Not connected");
        }
        try {
            return this.channel.writeAndFlush(new TextWebSocketFrame(WebSocketClient.MAPPER.writeValueAsString(message)));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    public ChannelFuture connectFuture() {
        return this.future;
    }

    public Channel channel() {
        return this.channel;
    }
}

