/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.core;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.shaded.com.fasterxml.jackson.annotation.JsonProperty;

public class Stream
extends BaseDataSiftResult {
    @JsonProperty(value="created_at")
    protected String createdAt;
    @JsonProperty
    protected float dpu;
    @JsonProperty
    protected String hash;

    public static Stream fromString(String str) {
        if (str == null || str.isEmpty()) {
            throw new IllegalArgumentException("Cannot create a stream from an empty or null string");
        }
        Stream stream = new Stream();
        stream.hash = str;
        return stream;
    }

    public String getCreatedAt() {
        return this.createdAt;
    }

    public float getDpu() {
        return this.dpu;
    }

    @JsonProperty
    public String hash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stream stream = (Stream)o;
        if (Float.compare(stream.dpu, this.dpu) != 0) {
            return false;
        }
        if (this.createdAt != null ? !this.createdAt.equals(stream.createdAt) : stream.createdAt != null) {
            return false;
        }
        return !(this.hash != null ? !this.hash.equals(stream.hash) : stream.hash != null);
    }

    public int hashCode() {
        int result = this.createdAt != null ? this.createdAt.hashCode() : 0;
        result = 31 * result + (this.dpu != 0.0f ? Float.floatToIntBits(this.dpu) : 0);
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        return result;
    }

    public boolean isSameAs(String hash) {
        return this.hash.equals(hash);
    }

    public boolean isSameAs(Stream hash) {
        return this.hash.equals(hash.hash);
    }
}

