/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client;

import com.datasift.shaded.io.higgs.http.client.FutureResponse;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.Response;
import com.datasift.shaded.io.higgs.http.client.RetryPolicy;
import com.datasift.shaded.io.netty.channel.ChannelHandlerContext;
import com.datasift.shaded.io.netty.channel.SimpleChannelInboundHandler;
import com.datasift.shaded.io.netty.handler.codec.http.HttpContent;
import com.datasift.shaded.io.netty.handler.codec.http.HttpHeaders;
import com.datasift.shaded.io.netty.handler.codec.http.HttpResponse;
import com.datasift.shaded.io.netty.handler.codec.http.LastHttpContent;
import com.datasift.shaded.io.netty.util.concurrent.Future;
import com.datasift.shaded.io.netty.util.concurrent.GenericFutureListener;

public class ClientHandler
extends SimpleChannelInboundHandler<Object> {
    private final Response response;
    private final FutureResponse future;
    private boolean redirecting;
    protected RetryPolicy policy;

    public ClientHandler(Response response, FutureResponse future, RetryPolicy policy) {
        this.future = future;
        this.response = response;
        this.policy = policy;
    }

    @Override
    public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpResponse) {
            HttpResponse res = (HttpResponse)msg;
            String location = res.headers().get("Location");
            if (this.response.request().redirectOn().contains(res.getStatus().code()) && location != null) {
                ((Request)this.response.request().url(location)).execute().addListener(new GenericFutureListener<Future<Response>>(){

                    @Override
                    public void operationComplete(Future<Response> f) throws Exception {
                        if (!f.isSuccess()) {
                            ClientHandler.this.future.setFailure(f.cause());
                        }
                    }
                });
                this.redirecting = true;
                return;
            }
            this.response.setStatus(res.getStatus());
            this.response.setProtocolVersion(res.getProtocolVersion());
            this.response.setHeaders(res.headers());
            if (HttpHeaders.isTransferEncodingChunked(res)) {
                this.response.setChunked(true);
            }
            if (this.policy != null && this.response.request().retryOn().contains(res.getStatus().code())) {
                this.policy.activate(this.future, null, false, this.response);
                return;
            }
        }
        if (!this.redirecting && msg instanceof HttpContent) {
            HttpContent chunk = (HttpContent)msg;
            this.response.write(chunk.content());
            if (chunk instanceof LastHttpContent) {
                ctx.channel().close();
                this.response.setCompleted(true);
                if (!this.future.isDone()) {
                    this.future.setSuccess(this.response);
                }
            }
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.policy != null) {
            this.policy.activate(this.future, cause, false, this.response);
        } else {
            this.future.setFailure(cause);
            ctx.channel().close();
        }
    }
}

