/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client;

import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.datasift.shaded.io.higgs.core.func.Function1;
import com.datasift.shaded.io.higgs.http.client.FutureResponse;
import com.datasift.shaded.io.higgs.http.client.HttpRequestBuilder;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.Reader;
import com.datasift.shaded.io.netty.bootstrap.Bootstrap;
import com.datasift.shaded.io.netty.buffer.ByteBuf;
import com.datasift.shaded.io.netty.buffer.Unpooled;
import com.datasift.shaded.io.netty.channel.Channel;
import com.datasift.shaded.io.netty.channel.ChannelFuture;
import com.datasift.shaded.io.netty.channel.ChannelHandler;
import com.datasift.shaded.io.netty.channel.ChannelHandlerContext;
import com.datasift.shaded.io.netty.channel.ChannelOption;
import com.datasift.shaded.io.netty.channel.DefaultChannelPromise;
import com.datasift.shaded.io.netty.channel.EventLoopGroup;
import com.datasift.shaded.io.netty.handler.codec.MessageToByteEncoder;
import com.datasift.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import com.datasift.shaded.io.netty.handler.codec.http.HttpMethod;
import com.datasift.shaded.io.netty.handler.codec.http.HttpVersion;
import com.datasift.shaded.io.netty.handler.ssl.SslHandler;
import com.datasift.shaded.io.netty.util.concurrent.Future;
import com.datasift.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.List;

public class HTTPStreamingRequest
extends Request<HTTPStreamingRequest> {
    private static final byte[] CRLF = new byte[]{13, 10};

    public HTTPStreamingRequest(HttpRequestBuilder builder, EventLoopGroup group, URI uri, Reader f) {
        super(builder, group, uri, HttpMethod.POST, HttpVersion.HTTP_1_1, f);
    }

    @Override
    protected void newNettyRequest(URI uri, HttpMethod method, HttpVersion version) {
        this.request = new DefaultHttpRequest(version, method, uri.getRawPath());
        this.headers().set("Referer", (Object)(this.originalUri == null ? uri.toString() : this.originalUri.toString()));
    }

    @Override
    public FutureResponse execute(Function1<Bootstrap> conf) {
        if (!this.request.headers().contains("Content-Type")) {
            this.request.headers().set("Content-Type", (Object)"application/json");
        }
        if (!this.request.headers().contains("Content-Length")) {
            this.request.headers().remove("Content-Length");
        }
        if (!this.request.headers().contains("Connection")) {
            this.request.headers().remove("Connection");
        }
        this.request.headers().set("Transfer-Encoding", (Object)"chunked");
        this.request.headers().set("Expect", (Object)"100-continue");
        FutureResponse res = super.execute(conf);
        this.channel.config().setOption(ChannelOption.ALLOW_HALF_CLOSURE, false);
        return res;
    }

    public void onReady(final Function1<StreamSender> listener) {
        if (this.connectFuture == null) {
            throw new IllegalStateException("Not connected");
        }
        this.connectFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    SslHandler sslHandler;
                    SslHandler sslHandler2 = sslHandler = HTTPStreamingRequest.this.channel.pipeline().get("ssl") instanceof SslHandler ? (SslHandler)HTTPStreamingRequest.this.channel.pipeline().get("ssl") : null;
                    if (sslHandler == null && HTTPStreamingRequest.this.useSSL) {
                        throw new IllegalStateException("SSL request but 'ssl' handler in the pipeline is not an SslHandler instance");
                    }
                    if (sslHandler != null) {
                        sslHandler.handshakeFuture().addListener((GenericFutureListener<Future<Channel>>)new GenericFutureListener<Future<? super Channel>>(){

                            @Override
                            public void operationComplete(Future<? super Channel> future) throws Exception {
                                if (future.isSuccess()) {
                                    this.connected();
                                } else {
                                    HTTPStreamingRequest.this.response.markFailed(future.cause());
                                }
                            }
                        });
                    } else {
                        this.connected();
                    }
                }
            }

            private void connected() {
                StreamSender sender = new StreamSender(HTTPStreamingRequest.this.channel);
                List<String> names = HTTPStreamingRequest.this.channel.pipeline().names();
                for (String name : names) {
                    ChannelHandler handler = HTTPStreamingRequest.this.channel.pipeline().get(name);
                    if (handler instanceof SslHandler || handler == null) continue;
                    HTTPStreamingRequest.this.channel.pipeline().remove(name);
                }
                HTTPStreamingRequest.this.channel.pipeline().addLast("raw-content-encoder", (ChannelHandler)new MessageToByteEncoder<Chunk>(){

                    @Override
                    protected void encode(ChannelHandlerContext ctx, Chunk msg, ByteBuf out) throws Exception {
                        out.writeBytes(Integer.toHexString(msg.data.readableBytes()).getBytes());
                        out.writeBytes(CRLF);
                        out.writeBytes(msg.data);
                        out.writeBytes(CRLF);
                        msg.future.setSuccess();
                    }
                });
                listener.apply(sender);
            }
        });
    }

    public static class StreamSender {
        protected final ObjectMapper MAPPER = new ObjectMapper();
        private final Channel channel;

        public StreamSender(Channel channel) {
            if (channel == null) {
                throw new IllegalArgumentException("Channel cannot be null");
            }
            this.channel = channel;
        }

        public ChannelFuture send(Object content) throws JsonProcessingException {
            return this.send(this.channel.alloc().ioBuffer().writeBytes(this.MAPPER.writeValueAsBytes(content)));
        }

        public ChannelFuture send(String content) {
            return this.send(Unpooled.wrappedBuffer(content.getBytes()));
        }

        public synchronized ChannelFuture send(ByteBuf content) {
            DefaultChannelPromise promise = new DefaultChannelPromise(this.channel);
            try {
                this.channel.writeAndFlush(new Chunk(promise, content));
            }
            catch (Exception e) {
                promise.setFailure(e);
            }
            return promise;
        }
    }

    public static class Chunk {
        public final DefaultChannelPromise future;
        public final ByteBuf data;

        public Chunk(DefaultChannelPromise future, ByteBuf data) {
            this.future = future;
            this.data = data;
        }
    }
}

