/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.accounts;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.ParamBuilder;
import com.datasift.client.accounts.Identity;
import com.datasift.client.accounts.IdentityList;
import com.datasift.client.accounts.Limit;
import com.datasift.client.accounts.LimitList;
import com.datasift.client.accounts.NewIdentity;
import com.datasift.client.accounts.NewLimit;
import com.datasift.client.accounts.NewLimitValue;
import com.datasift.client.accounts.NewToken;
import com.datasift.client.accounts.NewTokenValue;
import com.datasift.client.accounts.Token;
import com.datasift.client.accounts.TokenList;
import com.datasift.client.accounts.UsageResult;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.io.higgs.http.client.JSONRequest;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.PageReader;
import java.net.URI;

public class DataSiftAccount
extends DataSiftApiClient {
    public final String IDENTITY = "account/identity";
    public final String USAGE = "account/usage";

    public DataSiftAccount(DataSiftConfig config) {
        super(config);
    }

    public FutureData<Identity> create(String label) {
        return this.create(label, true, false);
    }

    public FutureData<Identity> create(String label, boolean active) {
        return this.create(label, active, false);
    }

    public FutureData<Identity> create(String label, boolean active, boolean master) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("A label is required");
        }
        String activeStr = active ? "active" : "disabled";
        FutureData<Identity> future = new FutureData<Identity>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity"));
        try {
            JSONRequest request = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new Identity(), this.config))).setData(new NewIdentity(label, activeStr, master));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return future;
    }

    public FutureData<Identity> update(String id, String label, Boolean active, Boolean master) {
        String activeStr = null;
        if (active != null) {
            activeStr = active != false ? "active" : "disabled";
        }
        FutureData<Identity> future = new FutureData<Identity>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + id));
        try {
            JSONRequest request = this.config.http().putJSON(uri, new PageReader(this.newRequestCallback(future, new Identity(), this.config))).setData(new NewIdentity(label, activeStr, master));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return future;
    }

    public FutureData<IdentityList> list() {
        return this.list(null, 0, 0);
    }

    public FutureData<IdentityList> list(String label) {
        return this.list(label, 0, 0);
    }

    public FutureData<IdentityList> list(int page) {
        return this.list(null, page, 0);
    }

    public FutureData<IdentityList> list(String label, int page) {
        return this.list(label, page, 0);
    }

    public FutureData<IdentityList> list(int page, int perPage) {
        return this.list(null, page, perPage);
    }

    public FutureData<IdentityList> list(String label, int page, int perPage) {
        FutureData<IdentityList> future = new FutureData<IdentityList>();
        ParamBuilder b = this.newParams();
        if (label != null) {
            b.put("label", label);
        }
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI("account/identity"));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new IdentityList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<Identity> get(String id) {
        FutureData<Identity> future = new FutureData<Identity>();
        URI uri = this.newParams().put("id", id).forURL(this.config.newAPIEndpointURI("account/identity/" + id));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new Identity(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> delete(String id) {
        if (id == null) {
            throw new IllegalArgumentException("An identity is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + id));
        Request request = this.config.http().DELETE(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<TokenList> listTokens(String identity) {
        return this.listTokens(identity, 0, 0);
    }

    public FutureData<TokenList> listTokens(String identity, int page) {
        return this.listTokens(identity, page, 0);
    }

    public FutureData<TokenList> listTokens(String identity, int page, int perPage) {
        if (identity == null) {
            throw new IllegalArgumentException("An identity is required");
        }
        FutureData<TokenList> future = new FutureData<TokenList>();
        ParamBuilder b = this.newParams();
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/token"));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new TokenList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<Token> getToken(String identity, String service) {
        FutureData<Token> future = new FutureData<Token>();
        URI uri = this.newParams().put("id", identity).forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/token/" + service));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new Token(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<Token> createToken(String identity, String service, String token) {
        if (service == null || service.isEmpty()) {
            throw new IllegalArgumentException("A service is required");
        }
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("A token is required");
        }
        FutureData<Token> future = new FutureData<Token>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/token"));
        try {
            JSONRequest request = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new Token(), this.config))).setData(new NewToken(service, token));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return future;
    }

    public FutureData<DataSiftResult> deleteToken(String identity, String service) {
        if (identity == null) {
            throw new IllegalArgumentException("An identity is required");
        }
        if (service == null) {
            throw new IllegalArgumentException("A service is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/token/" + service));
        Request request = this.config.http().DELETE(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<Token> updateToken(String identity, String service, String token) {
        if (identity == null || identity.isEmpty()) {
            throw new IllegalArgumentException("An identity is required");
        }
        if (service == null || service.isEmpty()) {
            throw new IllegalArgumentException("A service is required");
        }
        if (token == null || token.isEmpty()) {
            throw new IllegalArgumentException("A token is required");
        }
        FutureData<Token> future = new FutureData<Token>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/token/" + service));
        try {
            JSONRequest request = this.config.http().putJSON(uri, new PageReader(this.newRequestCallback(future, new Token(), this.config))).setData(new NewTokenValue(token));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return future;
    }

    public FutureData<Limit> getLimit(String identity, String service) {
        FutureData<Limit> future = new FutureData<Limit>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/limit/" + service));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new Limit(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<Limit> createLimit(String identity, String service, Long allowance) {
        if (identity == null || identity.isEmpty()) {
            throw new IllegalArgumentException("An identity is required");
        }
        if (service == null || service.isEmpty()) {
            throw new IllegalArgumentException("A service is required");
        }
        if (allowance < 0L) {
            throw new IllegalArgumentException("Allowance must be a positive integer");
        }
        FutureData<Limit> future = new FutureData<Limit>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/limit"));
        try {
            JSONRequest request = this.config.http().postJSON(uri, new PageReader(this.newRequestCallback(future, new Limit(), this.config))).setData(new NewLimit(service, allowance));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return future;
    }

    public FutureData<LimitList> listLimits(String service) {
        return this.listLimits(service, 0, 0);
    }

    public FutureData<LimitList> listLimits(String service, int page) {
        return this.listLimits(service, page, 0);
    }

    public FutureData<LimitList> listLimits(String service, int page, int perPage) {
        if (service == null || service.isEmpty()) {
            throw new IllegalArgumentException("A service is required");
        }
        FutureData<LimitList> future = new FutureData<LimitList>();
        ParamBuilder b = this.newParams();
        if (page > 0) {
            b.put("page", page);
        }
        if (perPage > 0) {
            b.put("per_page", perPage);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI("account/identity/limit/" + service));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new LimitList(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> deleteLimit(String identity, String service) {
        if (identity == null) {
            throw new IllegalArgumentException("An identity is required");
        }
        if (service == null) {
            throw new IllegalArgumentException("A service is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/limit/" + service));
        Request request = this.config.http().DELETE(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config)));
        this.performRequest(future, request);
        return future;
    }

    public FutureData<Limit> updateLimit(String identity, String service, Long allowance) {
        if (identity == null || identity.isEmpty()) {
            throw new IllegalArgumentException("An identity is required");
        }
        if (service == null || service.isEmpty()) {
            throw new IllegalArgumentException("A service is required");
        }
        if (allowance < 0L) {
            throw new IllegalArgumentException("Allowance must be a positive integer");
        }
        FutureData<Limit> future = new FutureData<Limit>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("account/identity/" + identity + "/limit/" + service));
        try {
            JSONRequest request = this.config.http().putJSON(uri, new PageReader(this.newRequestCallback(future, new Limit(), this.config))).setData(new NewLimitValue(allowance));
            this.performRequest(future, request);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        return future;
    }

    public FutureData<UsageResult> getUsage(String period, int start, int end) {
        FutureData<UsageResult> future = new FutureData<UsageResult>();
        if (start != 0 && end != 0 && start >= end) {
            throw new IllegalArgumentException("getUsage start timestamp must be earlier than the end timestamp");
        }
        ParamBuilder b = this.newParams();
        if (period != null && period.length() > 0) {
            b.put("period", period);
        }
        if (start != 0) {
            b.put("start", start);
        }
        if (end != 0) {
            b.put("end", end);
        }
        URI uri = b.forURL(this.config.newAPIEndpointURI("account/usage"));
        Request request = this.config.http().GET(uri, new PageReader(this.newRequestCallback(future, new UsageResult(), this.config)));
        this.performRequest(future, request);
        return future;
    }
}

