/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.historics;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.historics.HistoricsQuery;
import com.datasift.client.historics.HistoricsQueryList;
import com.datasift.client.historics.HistoricsStatus;
import com.datasift.client.historics.PreparedHistoricsQuery;
import com.datasift.shaded.io.higgs.http.client.POST;
import com.datasift.shaded.io.higgs.http.client.readers.PageReader;
import com.datasift.shaded.org.joda.time.DateTime;
import java.net.URI;
import java.util.concurrent.TimeUnit;

public class DataSiftHistorics
extends DataSiftApiClient {
    public final String PREPARE = "historics/prepare";
    public final String START = "historics/start";
    public final String STOP = "historics/stop";
    public final String UPDATE = "historics/update";
    public final String STATUS = "historics/status";
    public final String DELETE = "historics/delete";
    public final String GET = "historics/get";

    public DataSiftHistorics(DataSiftConfig config) {
        super(config);
    }

    public FutureData<DataSiftResult> start(PreparedHistoricsQuery query) {
        return this.start(FutureData.wrap(query));
    }

    public FutureData<DataSiftResult> start(FutureData<PreparedHistoricsQuery> query) {
        if (query == null) {
            throw new IllegalArgumentException("A valid PreparedHistoricsQuery is required");
        }
        final FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        BaseDataSiftResult h = new BaseDataSiftResult();
        FutureResponse<PreparedHistoricsQuery> r = new FutureResponse<PreparedHistoricsQuery>(){

            @Override
            public void apply(PreparedHistoricsQuery data) {
                if (data.getId() == null || data.getId().isEmpty()) {
                    throw new IllegalArgumentException("A valid PreparedHistoricsQuery is required");
                }
                DataSiftHistorics.this.start(data.getId(), future);
            }
        };
        this.unwrapFuture(query, future, h, r);
        return future;
    }

    public FutureData<DataSiftResult> start(String id) {
        return this.start(id, null);
    }

    protected FutureData<DataSiftResult> start(String id, FutureData<DataSiftResult> f) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A valid ID is required to start a Historics query");
        }
        FutureData<DataSiftResult> future = f != null ? f : new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/start"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> stop(PreparedHistoricsQuery query, String reason) {
        if (query == null || query.getId() == null || query.getId().isEmpty()) {
            throw new IllegalArgumentException("A valid PreparedHistoricsQuery is required");
        }
        return this.stop(query.getId(), reason);
    }

    public FutureData<DataSiftResult> stop(String id, String reason) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A valid ID is required to stop a Historics query");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/stop"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", id);
        if (reason != null) {
            request.form("reason", reason);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> delete(PreparedHistoricsQuery query) {
        if (query == null || query.getId() == null || query.getId().isEmpty()) {
            throw new IllegalArgumentException("A valid PreparedHistoricsQuery is required");
        }
        return this.delete(query.getId());
    }

    public FutureData<DataSiftResult> delete(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A valid ID is required to delete a Historics query");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/delete"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> update(String id, String name) {
        if (id == null || name == null || id.isEmpty() || name.isEmpty()) {
            throw new IllegalArgumentException("A valid ID AND name is required to update a Historics query");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/update"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", id).form("name", name);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<HistoricsStatus> status(DateTime start, DateTime end, String ... sources) {
        FutureData<HistoricsStatus> future = new FutureData<HistoricsStatus>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/status"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new HistoricsStatus(), this.config))).form("start", TimeUnit.MILLISECONDS.toSeconds(start.getMillis())).form("end", TimeUnit.MILLISECONDS.toSeconds(end.getMillis()));
        if (sources != null && sources.length > 0) {
            StringBuilder b = new StringBuilder();
            for (String source : sources) {
                b.append(source).append(",");
            }
            request.form("sources", b.toString().substring(0, b.length() - 1));
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<HistoricsQuery> get(String id) {
        return this.get(id, true);
    }

    public FutureData<HistoricsQuery> get(String id, boolean withEstimate) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("ID is required get a historics query");
        }
        FutureData<HistoricsQuery> future = new FutureData<HistoricsQuery>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/get"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new HistoricsQuery(), this.config))).form("id", id).form("with_estimate", withEstimate ? 1 : 0);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<HistoricsQueryList> list() {
        return this.list(100, 1, true);
    }

    public FutureData<HistoricsQueryList> list(int max, int page) {
        return this.list(max, page, true);
    }

    public FutureData<HistoricsQueryList> list(int page) {
        return this.list(100, page, true);
    }

    public FutureData<HistoricsQueryList> list(int max, int page, boolean withEstimate) {
        FutureData<HistoricsQueryList> future = new FutureData<HistoricsQueryList>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/get"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new HistoricsQueryList(), this.config))).form("with_estimate", withEstimate ? 1 : 0);
        if (max > 0) {
            request.form("max", max);
        }
        if (page > 0) {
            request.form("page", page);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PreparedHistoricsQuery> prepare(String hash, DateTime start, DateTime end, String name, String ... sources) {
        return this.prepare(hash, TimeUnit.MILLISECONDS.toSeconds(start.getMillis()), TimeUnit.MILLISECONDS.toSeconds(end.getMillis()), name, -1, sources);
    }

    public FutureData<PreparedHistoricsQuery> prepare(String hash, long start, long end, String name, String ... sources) {
        return this.prepare(hash, start, end, name, -1, sources);
    }

    public FutureData<PreparedHistoricsQuery> prepare(String hash, long start, long end, String name, int sample, String ... sources) {
        FutureData<PreparedHistoricsQuery> future = new FutureData<PreparedHistoricsQuery>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("historics/prepare"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PreparedHistoricsQuery(), this.config))).form("hash", hash).form("start", start).form("end", end).form("name", name);
        if (sample > 0) {
            request.form("sample", sample);
        }
        if (sources == null || sources.length == 0) {
            sources = new String[]{"tumblr"};
        }
        StringBuilder b = new StringBuilder();
        for (String source : sources) {
            b.append(source).append(",");
        }
        request.form("sources", b.toString().substring(0, b.length() - 1));
        this.performRequest(future, request);
        return future;
    }
}

