/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource.sources;

import com.datasift.client.DataSiftConfig;
import com.datasift.client.managedsource.ManagedDataSourceType;
import com.datasift.client.managedsource.sources.BaseSource;

public class Instagram
extends BaseSource<Instagram> {
    public Instagram(DataSiftConfig config) {
        super(config, ManagedDataSourceType.INSTAGRAM);
    }

    public Instagram enableLikes(boolean enabled) {
        return (Instagram)this.setParametersField("likes", enabled);
    }

    public Instagram enableComments(boolean enabled) {
        return (Instagram)this.setParametersField("comments", enabled);
    }

    public Instagram enableCommentCounts(boolean enabled) {
        return (Instagram)this.setParametersField("comment_count", enabled);
    }

    public Instagram enableLikeCounts(boolean enabled) {
        return (Instagram)this.setParametersField("like_count", enabled);
    }

    public Instagram byTag(String tag, boolean exactMatch) {
        this.addResource(Type.TAG, tag, -1.0f, -1.0f, -1, exactMatch, null);
        return this;
    }

    protected Instagram addResource(Type type, String value, float longitude, float lattitude, int distance, boolean exactMatch, String fourSquareLocation) {
        BaseSource.ResourceParams parameterSet = this.newResourceParams();
        switch (type) {
            case TAG: {
                if (value == null) {
                    throw new IllegalArgumentException("If type is user then value is required");
                }
                parameterSet.set("type", "tag");
                parameterSet.set("value", value);
                parameterSet.set("extact_match", exactMatch);
            }
        }
        return this;
    }

    public Instagram addOAutToken(String oAuthAccessToken, long expires, String name) {
        if (oAuthAccessToken == null || oAuthAccessToken.isEmpty()) {
            throw new IllegalArgumentException("A valid OAuth and refresh token is required");
        }
        BaseSource.AuthParams parameterSet = this.newAuthParams(name, expires);
        parameterSet.set("value", oAuthAccessToken);
        return this;
    }

    public static enum Type {
        TAG;

    }
}

