/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push;

import com.datasift.client.BaseDataSiftResult;
import com.datasift.client.DataSiftApiClient;
import com.datasift.client.DataSiftConfig;
import com.datasift.client.DataSiftResult;
import com.datasift.client.FutureData;
import com.datasift.client.FutureResponse;
import com.datasift.client.core.Stream;
import com.datasift.client.exceptions.AuthException;
import com.datasift.client.exceptions.DataSiftException;
import com.datasift.client.historics.HistoricsQuery;
import com.datasift.client.historics.PreparedHistoricsQuery;
import com.datasift.client.push.PullReader;
import com.datasift.client.push.PulledInteractions;
import com.datasift.client.push.PushCollection;
import com.datasift.client.push.PushLogMessages;
import com.datasift.client.push.PushSubscription;
import com.datasift.client.push.PushValidation;
import com.datasift.client.push.Status;
import com.datasift.client.push.connectors.PushConnector;
import com.datasift.client.push.pull.LastInteraction;
import com.datasift.client.push.pull.PullJsonType;
import com.datasift.shaded.io.higgs.http.client.HttpRequestBuilder;
import com.datasift.shaded.io.higgs.http.client.POST;
import com.datasift.shaded.io.higgs.http.client.readers.PageReader;
import com.datasift.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import com.datasift.shaded.org.joda.time.DateTime;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class DataSiftPush
extends DataSiftApiClient {
    public final String VALIDATE = "push/validate";
    public final String CREATE = "push/create";
    public final String PAUSE = "push/pause";
    public final String RESUME = "push/resume";
    public final String UPDATE = "push/update";
    public final String STOP = "push/stop";
    public final String DELETE = "push/delete";
    public final String LOG = "push/log";
    public final String GET = "push/get";
    public final String PULL = "pull";

    public DataSiftPush(DataSiftConfig config) {
        super(config);
    }

    public FutureData<PushSubscription> pause(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/pause"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PushSubscription> resume(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/resume"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PushSubscription> stop(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/stop"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<DataSiftResult> delete(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        FutureData<DataSiftResult> future = new FutureData<DataSiftResult>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/delete"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new BaseDataSiftResult(), this.config))).form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PushSubscription> update(String id, PushConnector connector) {
        return this.update(id, connector, null);
    }

    public FutureData<PushSubscription> update(String id, PushConnector connector, String name) {
        if (id == null || id.isEmpty() || connector == null) {
            throw new IllegalArgumentException("A push subscription ID and output parameters is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/update"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("id", id);
        for (Map.Entry<String, String> e : connector.parameters().verifyAndGet().entrySet()) {
            request.form(e.getKey(), e.getValue());
        }
        if (name != null && !name.isEmpty()) {
            request.form("name", name);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PulledInteractions> pull(PushSubscription id) {
        return this.pull(id, 0, null);
    }

    public FutureData<PulledInteractions> pull(final PushSubscription id, final int size, String cursor) {
        if (id == null || id.getId() == null || id.getId().isEmpty()) {
            throw new IllegalArgumentException("A push subscription ID is required");
        }
        final FutureData<PulledInteractions> future = new FutureData<PulledInteractions>();
        final URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("pull"));
        final PulledInteractions interactions = new PulledInteractions();
        PullReader reader = new PullReader(interactions){
            private boolean failed;

            @Override
            public void onStatus(HttpResponseStatus status) {
                super.onStatus(status);
                if (this.response.hasFailed()) {
                    throw new DataSiftException("Failed to pull interactions", this.response.failureCause());
                }
                if (status.code() == 401) {
                    throw new AuthException("Please provide a valid username and API key", this.response);
                }
            }

            @Override
            public void done() {
                PushSubscription subscription;
                super.done();
                if (this.failed && this.status == 204) {
                    this.stopPullingAndInsertLastInteraction();
                    return;
                }
                1 internalReader = this;
                if (this.status == 204 && this.successiveNoContent >= 5 && (subscription = DataSiftPush.this.get(id.getId()).sync()).status() != null) {
                    Status s = subscription.status();
                    if (s.isWaitingForStart()) {
                        this.backOff = new Long(subscription.getStart() - TimeUnit.MILLISECONDS.toSeconds(DateTime.now().getMillis())).intValue();
                    } else if (s.isFinished()) {
                        this.stopPullingAndInsertLastInteraction();
                    }
                }
                if (this.status == 204 && interactions.isPulling() || interactions.isPulling() && this.nextCursor != null && !this.nextCursor.isEmpty()) {
                    this.schedulePoll(internalReader);
                } else {
                    subscription = DataSiftPush.this.get(id.getId()).sync();
                    this.failed = subscription.status().isFailed();
                    if (subscription.status().isFinished()) {
                        this.stopPullingAndInsertLastInteraction();
                    } else {
                        this.schedulePoll(internalReader);
                    }
                }
                this.reset();
            }

            protected void stopPullingAndInsertLastInteraction() {
                interactions.add(LastInteraction.INSTANCE);
                interactions.stopPulling();
            }

            protected void schedulePoll(final PullReader internalReader) {
                HttpRequestBuilder.group().schedule(new Runnable(){

                    @Override
                    public void run() {
                        DataSiftPush.this.sendPullRequest(future, id, size, nextCursor, uri, internalReader);
                    }
                }, (long)this.backOff, TimeUnit.SECONDS);
            }
        };
        this.sendPullRequest(future, id, size, cursor, uri, reader);
        future.received(interactions);
        return future;
    }

    protected void sendPullRequest(FutureData<PulledInteractions> future, PushSubscription id, int size, String cursor, URI uri, PullReader reader) {
        POST request = this.config.http().POST(uri, reader).form("id", id.getId());
        if (cursor != null && !cursor.isEmpty()) {
            request.form("cursor", cursor);
        }
        if (size > 0) {
            request.form("size", size);
        }
        this.performRequest(future, request);
    }

    public FutureData<PushLogMessages> log(String id, int page) {
        return this.log(id, page, 0, null, null);
    }

    public FutureData<PushLogMessages> log(String id, int page, int perPage, String orderBy, String orderDirection) {
        FutureData<PushLogMessages> future = new FutureData<PushLogMessages>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/log"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushLogMessages(), this.config)));
        if (id != null && !id.isEmpty()) {
            request.form("id", id);
        }
        if (page > 0) {
            request.form("page", page);
        }
        if (perPage > 0) {
            request.form("per_page", perPage);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            request.form("order_by", orderBy);
        }
        if (orderDirection != null && !orderDirection.isEmpty()) {
            request.form("order_dir", orderDirection);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PushSubscription> get(String id) {
        if (id == null) {
            throw new IllegalArgumentException("A subscription ID is required");
        }
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/get"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config)));
        request.form("id", id);
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PushCollection> get(int page, int perPage, String orderBy, String orderDirection, boolean includeFinished) {
        FutureData<PushCollection> future = new FutureData<PushCollection>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/get"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushCollection(), this.config)));
        request.form("include_finished", includeFinished ? 1 : 0);
        if (page > 0) {
            request.form("page", page);
        }
        if (perPage > 0) {
            request.form("per_page", perPage);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            request.form("order_by", orderBy);
        }
        if (orderDirection != null && !orderDirection.isEmpty()) {
            request.form("order_dir", orderDirection);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PushCollection> get(Stream hash, int page, int perPage, String orderBy, String orderDirection, boolean includeFinished) {
        FutureData<PushCollection> future = new FutureData<PushCollection>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/get"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushCollection(), this.config)));
        request.form("hash", hash.hash()).form("include_finished", includeFinished ? 1 : 0);
        if (page > 0) {
            request.form("page", page);
        }
        if (perPage > 0) {
            request.form("per_page", perPage);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            request.form("order_by", orderBy);
        }
        if (orderDirection != null && !orderDirection.isEmpty()) {
            request.form("order_dir", orderDirection);
        }
        this.performRequest(future, request);
        return future;
    }

    public FutureData<PushCollection> get(HistoricsQuery historics, int page, int perPage, String orderBy, String orderDirection, boolean includeFinished) {
        FutureData<PushCollection> future = new FutureData<PushCollection>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/get"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushCollection(), this.config)));
        request.form("historics_id", historics.getId()).form("include_finished", includeFinished ? 1 : 0);
        if (page > 0) {
            request.form("page", page);
        }
        if (perPage > 0) {
            request.form("per_page", perPage);
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            request.form("order_by", orderBy);
        }
        if (orderDirection != null && !orderDirection.isEmpty()) {
            request.form("order_dir", orderDirection);
        }
        this.performRequest(future, request);
        return future;
    }

    public <T extends PushConnector> FutureData<PushValidation> validate(T connector) {
        FutureData<PushValidation> future = new FutureData<PushValidation>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/validate"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushValidation(), this.config))).form("output_type", connector.type().value());
        for (Map.Entry<String, String> e : connector.parameters().verifyAndGet().entrySet()) {
            request.form(e.getKey(), e.getValue());
        }
        this.performRequest(future, request);
        return future;
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T connector, FutureData<PreparedHistoricsQuery> historics, FutureData<Stream> stream, String name) {
        return this.create(connector, historics, stream, name, null, 0L, 0L);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T connector, PreparedHistoricsQuery historics, String name, Status initialStatus, long start, long end) {
        return this.create(connector, FutureData.wrap(historics), null, name, initialStatus, start, end);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T con, FutureData<PreparedHistoricsQuery> query, String name) {
        return this.create(con, query, null, name);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T con, Stream stream, String name) {
        return this.create(con, stream, name, null, 0L, 0L);
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(T connector, Stream stream, String name, Status initialStatus, long start, long end) {
        return this.create(connector, null, FutureData.wrap(stream), name, initialStatus, start, end);
    }

    public FutureData<PushSubscription> createPull(PullJsonType jsonMeta, PreparedHistoricsQuery historics, String name, Status initialStatus, long start, long end) {
        return this.createPull(jsonMeta, historics, null, name, initialStatus, start, end);
    }

    public FutureData<PushSubscription> createPull(PullJsonType jsonMeta, PreparedHistoricsQuery historics, String name) {
        return this.createPull(jsonMeta, historics, null, name, null, 0L, 0L);
    }

    public FutureData<PushSubscription> createPull(PullJsonType jsonMeta, Stream stream, String name, Status initialStatus, long start, long end) {
        return this.createPull(jsonMeta, null, stream, name, initialStatus, start, end);
    }

    public FutureData<PushSubscription> createPull(PullJsonType jsonMeta, Stream stream, String name) {
        return this.createPull(jsonMeta, null, stream, name, null, 0L, 0L);
    }

    public FutureData<PushSubscription> createPull(PullJsonType type, PreparedHistoricsQuery historics, Stream stream, String name, Status initialStatus, long start, long end) {
        FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/create"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, new PushSubscription(), this.config))).form("output_type", "pull").form("output_params.acl", "private").form("name", name);
        if (type != null) {
            request.form("output_params.format", type.asString());
        }
        if (historics != null && stream != null) {
            throw new IllegalStateException("Historics and Stream cannot both be specified");
        }
        if (historics == null && stream == null) {
            throw new IllegalArgumentException("At least one of Historics OR Stream must be specified");
        }
        if (historics != null) {
            request.form("historics_id", historics.getId());
        }
        if (stream != null) {
            request.form("hash", stream.hash());
        }
        if (initialStatus != null) {
            request.form("initial_status", initialStatus.val());
        }
        if (start > 0L) {
            request.form("start", start);
        }
        if (end > 0L) {
            request.form("end", end);
        }
        this.performRequest(future, request);
        return future;
    }

    public <T extends PushConnector> FutureData<PushSubscription> create(final T connector, FutureData<PreparedHistoricsQuery> historics, FutureData<Stream> stream, final String name, final Status initialStatus, final long start, final long end) {
        if (name == null) {
            throw new IllegalArgumentException("Name is required in order to create a push subscription");
        }
        if (historics != null && stream != null) {
            throw new IllegalArgumentException("A push subscription cannot be created with both a historic and live stream. One must be null");
        }
        if (end > 0L && end <= start) {
            throw new IllegalArgumentException("If end is specified it must be greater than the start");
        }
        final FutureData<PushSubscription> future = new FutureData<PushSubscription>();
        final PushSubscription subscription = new PushSubscription();
        if (historics != null) {
            this.unwrapFuture(historics, future, subscription, new FutureResponse<PreparedHistoricsQuery>(){

                @Override
                public void apply(PreparedHistoricsQuery data) {
                    DataSiftPush.this.performCreateQuery(connector, name, initialStatus, start, end, future, subscription, data, null);
                }
            });
        }
        if (stream != null) {
            this.unwrapFuture(stream, future, subscription, new FutureResponse<Stream>(){

                @Override
                public void apply(Stream data) {
                    DataSiftPush.this.performCreateQuery(connector, name, initialStatus, start, end, future, subscription, null, data);
                }
            });
        }
        return future;
    }

    private <T extends PushConnector> void performCreateQuery(T connector, String name, Status initialStatus, long start, long end, FutureData<PushSubscription> future, PushSubscription subscription, PreparedHistoricsQuery historics, Stream stream) {
        URI uri = this.newParams().forURL(this.config.newAPIEndpointURI("push/create"));
        POST request = this.config.http().POST(uri, new PageReader(this.newRequestCallback(future, subscription, this.config))).form("output_type", connector.type().value()).form("name", name);
        for (Map.Entry<String, String> e : connector.parameters().verifyAndGet().entrySet()) {
            request.form(e.getKey(), e.getValue());
        }
        if (historics != null) {
            request.form("historics_id", historics.getId());
        } else {
            request.form("hash", stream.hash());
        }
        if (initialStatus != null) {
            request.form("initial_status", initialStatus.val());
        }
        if (start > 0L) {
            request.form("start", start);
        }
        if (end > 0L) {
            request.form("end", end);
        }
        this.performRequest(future, request);
    }
}

