/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.com.fasterxml.jackson.databind.ser.impl;

import com.datasift.shaded.com.fasterxml.jackson.core.JsonGenerationException;
import com.datasift.shaded.com.fasterxml.jackson.core.JsonGenerator;
import com.datasift.shaded.com.fasterxml.jackson.databind.BeanProperty;
import com.datasift.shaded.com.fasterxml.jackson.databind.JavaType;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonNode;
import com.datasift.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import com.datasift.shaded.com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.datasift.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.datasift.shaded.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.node.ObjectNode;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.datasift.shaded.com.fasterxml.jackson.databind.ser.std.ArraySerializerBase;
import com.datasift.shaded.com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JacksonStdImpl
public class StringArraySerializer
extends ArraySerializerBase<String[]>
implements ContextualSerializer {
    private static final JavaType VALUE_TYPE = TypeFactory.defaultInstance().uncheckedSimpleType(String.class);
    public static final StringArraySerializer instance = new StringArraySerializer();
    protected final JsonSerializer<Object> _elementSerializer;

    protected StringArraySerializer() {
        super(String[].class, null);
        this._elementSerializer = null;
    }

    public StringArraySerializer(StringArraySerializer src, BeanProperty prop, JsonSerializer<?> ser) {
        super(src, prop);
        this._elementSerializer = ser;
    }

    @Override
    public ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
        return this;
    }

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider provider, BeanProperty property) throws JsonMappingException {
        Object serDef;
        AnnotatedMember m;
        JsonSerializer<Object> ser = null;
        if (property != null && (m = property.getMember()) != null && (serDef = provider.getAnnotationIntrospector().findContentSerializer(m)) != null) {
            ser = provider.serializerInstance(m, serDef);
        }
        if (ser == null) {
            ser = this._elementSerializer;
        }
        if (ser == null) {
            ser = provider.findValueSerializer(String.class, property);
        } else if (ser instanceof ContextualSerializer) {
            ser = ((ContextualSerializer)((Object)ser)).createContextual(provider, property);
        }
        if (this.isDefaultSerializer(ser)) {
            ser = null;
        }
        if (ser == this._elementSerializer) {
            return this;
        }
        return new StringArraySerializer(this, property, ser);
    }

    @Override
    public JavaType getContentType() {
        return VALUE_TYPE;
    }

    @Override
    public JsonSerializer<?> getContentSerializer() {
        return this._elementSerializer;
    }

    @Override
    public boolean isEmpty(String[] value) {
        return value == null || value.length == 0;
    }

    @Override
    public boolean hasSingleElement(String[] value) {
        return value.length == 1;
    }

    @Override
    public void serializeContents(String[] value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int len = value.length;
        if (len == 0) {
            return;
        }
        if (this._elementSerializer != null) {
            this.serializeContentsSlow(value, jgen, provider, this._elementSerializer);
            return;
        }
        for (int i = 0; i < len; ++i) {
            String str = value[i];
            if (str == null) {
                jgen.writeNull();
                continue;
            }
            jgen.writeString(value[i]);
        }
    }

    private void serializeContentsSlow(String[] value, JsonGenerator jgen, SerializerProvider provider, JsonSerializer<Object> ser) throws IOException, JsonGenerationException {
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            String str = value[i];
            if (str == null) {
                provider.defaultSerializeNull(jgen);
                continue;
            }
            ser.serialize(value[i], jgen, provider);
        }
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        o.put("items", this.createSchemaNode("string"));
        return o;
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectArrayFormat(typeHint).itemsFormat(JsonFormatTypes.STRING);
    }
}

