/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client;

import com.datasift.shaded.io.higgs.core.ssl.SSLConfigFactory;
import com.datasift.shaded.io.higgs.core.ssl.SSLContextFactory;
import com.datasift.shaded.io.higgs.http.client.HTTPStreamingRequest;
import com.datasift.shaded.io.higgs.http.client.JSONRequest;
import com.datasift.shaded.io.higgs.http.client.POST;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.Reader;
import com.datasift.shaded.io.netty.channel.EventLoopGroup;
import com.datasift.shaded.io.netty.channel.nio.NioEventLoopGroup;
import com.datasift.shaded.io.netty.handler.codec.http.HttpMethod;
import com.datasift.shaded.io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;

public class HttpRequestBuilder {
    private static final HttpRequestBuilder instance = new HttpRequestBuilder();
    protected static String proxyHost;
    protected static String proxyUsername;
    protected static String proxyPassword;
    protected static int proxyPort;
    private static EventLoopGroup group;
    protected String userAgent = "Mozilla/5.0 (compatible; HiggsBoson/0.0.1; +https://github.com/zcourts/higgs)";
    protected String charSet = "ISO-8859-1,utf-8;q=0.7,*;q=0.7";
    protected String acceptedLanguages = "en";
    protected String acceptedMimeTypes = "text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8";
    protected Set<Integer> redirectStatusCodes = new HashSet<Integer>();
    protected String acceptedEncodings = "gzip,deflate";
    protected String connectionHeader = "close";
    protected static final String thPrefix = "higgs-http-client-";
    protected static AtomicInteger thNum;
    protected static final SSLContextFactory sslCtx;

    public HttpRequestBuilder(HttpRequestBuilder that) {
        this();
        this.redirectStatusCodes.addAll(that.redirectStatusCodes);
        this.userAgent = that.userAgent;
        this.charSet = that.charSet;
        this.acceptedEncodings = that.acceptedEncodings;
        this.acceptedLanguages = that.acceptedLanguages;
        this.acceptedMimeTypes = that.acceptedMimeTypes;
        this.connectionHeader = that.connectionHeader;
    }

    public HttpRequestBuilder() {
        this.redirectStatusCodes.addAll(Arrays.asList(301, 302, 303, 307, 308));
    }

    public static HttpRequestBuilder instance() {
        return instance;
    }

    public static EventLoopGroup group() {
        return group;
    }

    public static void restart() {
        HttpRequestBuilder.shutdown();
        group = new NioEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread th = new Thread(r, HttpRequestBuilder.thPrefix + thNum.incrementAndGet());
                th.setDaemon(true);
                return th;
            }
        });
    }

    public static void shutdown() {
        if (group == null) {
            return;
        }
        group.shutdownGracefully();
    }

    public static boolean isSupportedSSLProtocol(String protocol) {
        if (protocol == null || protocol.isEmpty()) {
            throw new IllegalArgumentException("Protocol cannot be null or empty");
        }
        for (String v : HttpRequestBuilder.getSupportedSSLProtocols()) {
            if (!v.equalsIgnoreCase(protocol)) continue;
            return true;
        }
        return false;
    }

    public static String[] getSupportedSSLProtocols() {
        SSLEngine engine = sslCtx.getSSLSocket(SSLConfigFactory.sslConfiguration).createSSLEngine();
        engine.setUseClientMode(true);
        return engine.getSupportedProtocols();
    }

    public HttpRequestBuilder proxy(String host, int port) {
        return this.proxy(host, port, null, null);
    }

    public HttpRequestBuilder proxy(String host, int port, String username, String password) {
        proxyHost = host;
        proxyPort = port;
        proxyUsername = username;
        proxyPassword = password;
        return this;
    }

    public HttpRequestBuilder redirectOn(int ... codes) {
        for (int code : codes) {
            this.redirectStatusCodes.add(code);
        }
        return this;
    }

    public Set<Integer> redirectOn() {
        return this.redirectStatusCodes;
    }

    public Request GET(URI uri, Reader reader) {
        return this.GET(uri, HttpVersion.HTTP_1_1, reader);
    }

    public Request GET(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new Request(this, group, uri, HttpMethod.GET, version, reader);
    }

    private void checkGroup() {
        if (group == null || group.isShuttingDown() || group.isShutdown()) {
            HttpRequestBuilder.restart();
        }
    }

    public POST POST(URI uri, Reader reader) {
        return this.POST(uri, HttpVersion.HTTP_1_1, reader);
    }

    public POST POST(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new POST(this, group, uri, version, reader);
    }

    public HTTPStreamingRequest streamJSON(URI uri, Reader reader) {
        this.checkGroup();
        return new HTTPStreamingRequest(this, group, uri, reader);
    }

    public JSONRequest postJSON(URI uri, Reader reader) {
        return this.postJSON(uri, HttpVersion.HTTP_1_1, reader);
    }

    public JSONRequest postJSON(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new JSONRequest(this, group, uri, version, reader, HttpMethod.POST);
    }

    public JSONRequest putJSON(URI uri, Reader reader) {
        return this.putJSON(uri, HttpVersion.HTTP_1_1, reader);
    }

    public JSONRequest putJSON(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new JSONRequest(this, group, uri, version, reader, HttpMethod.PUT);
    }

    public Request DELETE(URI uri, Reader reader) {
        return this.DELETE(uri, HttpVersion.HTTP_1_1, reader);
    }

    public Request DELETE(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new Request(this, group, uri, HttpMethod.DELETE, version, reader);
    }

    public Request OPTIONS(URI uri, Reader reader) {
        return this.OPTIONS(uri, HttpVersion.HTTP_1_1, reader);
    }

    public Request OPTIONS(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new Request(this, group, uri, HttpMethod.OPTIONS, version, reader);
    }

    public Request HEAD(URI uri, Reader reader) {
        return this.HEAD(uri, HttpVersion.HTTP_1_1, reader);
    }

    public Request HEAD(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new Request(this, group, uri, HttpMethod.HEAD, version, reader);
    }

    public Request TRACE(URI uri, Reader reader) {
        return this.TRACE(uri, HttpVersion.HTTP_1_1, reader);
    }

    public Request TRACE(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new Request(this, group, uri, HttpMethod.TRACE, version, reader);
    }

    public Request PATCH(URI uri, Reader reader) {
        return this.PATCH(uri, HttpVersion.HTTP_1_1, reader);
    }

    public Request PATCH(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new Request(this, group, uri, HttpMethod.PATCH, version, reader);
    }

    public Request CONNECT(URI uri, Reader reader) {
        return this.CONNECT(uri, HttpVersion.HTTP_1_1, reader);
    }

    public Request CONNECT(URI uri, HttpVersion version, Reader reader) {
        this.checkGroup();
        return new Request(this, group, uri, HttpMethod.CONNECT, version, reader);
    }

    public HttpRequestBuilder acceptedLanguages(String acceptedLanguages) {
        this.acceptedLanguages = acceptedLanguages;
        return this;
    }

    public HttpRequestBuilder acceptedMimeTypes(String acceptedMimeTypes) {
        this.acceptedMimeTypes = acceptedMimeTypes;
        return this;
    }

    public HttpRequestBuilder charSet(String charSet) {
        this.charSet = charSet;
        return this;
    }

    public HttpRequestBuilder userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpRequestBuilder connection(String connectionHeader) {
        this.connectionHeader = connectionHeader;
        return this;
    }

    public HttpRequestBuilder copy() {
        return new HttpRequestBuilder(this);
    }

    static {
        proxyPort = 80;
        thNum = new AtomicInteger();
        sslCtx = new SSLContextFactory();
    }
}

