/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client;

import com.datasift.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import com.datasift.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.datasift.shaded.io.higgs.core.func.Function1;
import com.datasift.shaded.io.higgs.http.client.FutureResponse;
import com.datasift.shaded.io.higgs.http.client.HttpRequestBuilder;
import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.Reader;
import com.datasift.shaded.io.netty.bootstrap.Bootstrap;
import com.datasift.shaded.io.netty.buffer.Unpooled;
import com.datasift.shaded.io.netty.channel.EventLoopGroup;
import com.datasift.shaded.io.netty.handler.codec.http.HttpMethod;
import com.datasift.shaded.io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class JSONRequest
extends Request<JSONRequest> {
    protected final ObjectMapper MAPPER = new ObjectMapper();
    protected Map<String, Object> dataMap = new HashMap<String, Object>();

    public JSONRequest(HttpRequestBuilder builder, EventLoopGroup group, URI uri, HttpVersion version, Reader f, HttpMethod method) {
        super(builder, group, uri, method, version, f);
    }

    @Override
    public FutureResponse execute(Function1<Bootstrap> conf) {
        if (!this.request.headers().contains("Content-Type")) {
            this.request.headers().set("Content-Type", (Object)"application/json");
        }
        if (this.dataMap.size() > 0) {
            try {
                this.contents.writeBytes(Unpooled.wrappedBuffer(this.MAPPER.writeValueAsBytes(this.dataMap)));
            }
            catch (JsonProcessingException e) {
                throw new IllegalStateException("Unable to encode JSON data", e);
            }
        }
        this.request.headers().set("Content-Length", (Object)this.contents.readableBytes());
        return super.execute(conf);
    }

    public JSONRequest addField(String name, Object value) {
        if (this.contents.readableBytes() > 0) {
            throw new IllegalStateException("You cannot use addField in combination with setData");
        }
        this.dataMap.put(name, value);
        return this;
    }

    public JSONRequest setData(String data) {
        if (!this.dataMap.isEmpty()) {
            throw new IllegalStateException("You cannot use setData in combination with addField");
        }
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.contents.writeBytes(Unpooled.wrappedBuffer(data.getBytes(UTF8)));
        return this;
    }

    public JSONRequest setData(Object data) throws JsonProcessingException {
        if (!this.dataMap.isEmpty()) {
            throw new IllegalStateException("You cannot use setData in combination with addField");
        }
        if (data == null) {
            throw new IllegalArgumentException("data cannot be null");
        }
        this.contents.writeBytes(Unpooled.wrappedBuffer(this.MAPPER.writeValueAsBytes(data)));
        return this;
    }

    public ObjectMapper mapper() {
        return this.MAPPER;
    }
}

