/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.http.client;

import com.datasift.shaded.io.higgs.http.client.Request;
import com.datasift.shaded.io.higgs.http.client.readers.Reader;
import com.datasift.shaded.io.netty.buffer.ByteBuf;
import com.datasift.shaded.io.netty.handler.codec.http.HttpHeaders;
import com.datasift.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import com.datasift.shaded.io.netty.handler.codec.http.HttpVersion;

public class Response {
    protected final Request request;
    protected boolean failed;
    protected Throwable cause;
    protected Reader reader;
    private boolean chunked;
    private HttpVersion protocolVersion;
    private HttpResponseStatus status;
    private HttpHeaders headers;
    private boolean completed;

    public Response(Request request, Reader reader) {
        this.reader = reader;
        this.request = request;
        reader.response(this);
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public void setChunked(boolean chunked) {
        this.chunked = chunked;
    }

    public HttpVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(HttpVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
        this.reader.onProtocolVersion(protocolVersion);
    }

    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public void setStatus(HttpResponseStatus status) {
        this.status = status;
        this.reader.onStatus(status);
    }

    public HttpHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpHeaders headers) {
        this.headers = headers;
        this.reader.onHeaders(headers);
    }

    public void write(ByteBuf content) {
        if (content != null) {
            this.reader.data(content);
        }
    }

    public void markFailed(Throwable cause) {
        this.failed = true;
        this.cause = cause;
        this.setCompleted(true);
    }

    public boolean hasFailed() {
        return this.failed;
    }

    public Throwable failureCause() {
        return this.cause;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public void setCompleted(boolean completed) {
        this.completed = completed;
        this.reader.setCompleted(completed);
    }

    public String toString() {
        return "Response{chunked=" + this.chunked + ", protocolVersion=" + this.protocolVersion + ", status=" + this.status + ", headers=" + this.headers + ", completed=" + this.completed + ", reader=" + this.reader + ", \nrequest=" + this.request + '}';
    }

    public Request request() {
        return this.request;
    }

    public boolean isRedirected() {
        return this.request.originalUri() != null;
    }
}

