/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.shaded.io.higgs.ws.client;

import com.datasift.shaded.io.higgs.ws.client.WebSocketEventListener;
import com.datasift.shaded.io.higgs.ws.client.WebSocketMessage;
import com.datasift.shaded.io.netty.buffer.ByteBuf;
import com.datasift.shaded.io.netty.channel.Channel;
import com.datasift.shaded.io.netty.channel.ChannelFuture;
import com.datasift.shaded.io.netty.channel.ChannelHandlerContext;
import com.datasift.shaded.io.netty.channel.ChannelPromise;
import com.datasift.shaded.io.netty.channel.SimpleChannelInboundHandler;
import com.datasift.shaded.io.netty.handler.codec.DecoderResult;
import com.datasift.shaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import com.datasift.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import com.datasift.shaded.io.netty.handler.codec.http.FullHttpResponse;
import com.datasift.shaded.io.netty.handler.codec.http.HttpHeaders;
import com.datasift.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import com.datasift.shaded.io.netty.handler.codec.http.LastHttpContent;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import com.datasift.shaded.io.netty.handler.codec.http.websocketx.WebSocketFrame;
import com.datasift.shaded.io.netty.util.CharsetUtil;
import com.datasift.shaded.io.netty.util.concurrent.Future;
import com.datasift.shaded.io.netty.util.concurrent.GenericFutureListener;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class WebSocketClientHandler
extends SimpleChannelInboundHandler<Object> {
    protected final Set<WebSocketEventListener> listensers;
    private final WebSocketClientHandshaker handshaker;
    private final boolean autoPong;
    private ChannelPromise handshakeFuture;
    private FullHttpResponse response;
    private ChannelHandlerContext ctx;

    public WebSocketClientHandler(WebSocketClientHandshaker handshaker, Set<WebSocketEventListener> listeners, boolean autoPong) {
        this.handshaker = handshaker;
        this.listensers = listeners;
        this.autoPong = autoPong;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.handshakeFuture = ctx.newPromise();
    }

    @Override
    public void channelActive(ChannelHandlerContext c) throws Exception {
        this.doHandshake(c);
    }

    @Override
    public void channelInactive(ChannelHandlerContext c) throws Exception {
        for (WebSocketEventListener l : this.listensers) {
            l.onClose(c, null);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!this.handshakeFuture.isDone()) {
            this.handshakeFuture.setFailure(cause);
        }
        for (WebSocketEventListener l : this.listensers) {
            l.onError(ctx, cause, this.response);
        }
        ctx.close();
    }

    protected void doHandshake(final ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.handshaker.handshake(ctx.channel()).addListener((GenericFutureListener<? extends Future<? super Void>>)new GenericFutureListener<ChannelFuture>(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    WebSocketClientHandler.this.exceptionCaught(ctx, future.cause());
                }
            }
        });
    }

    @Override
    public void channelRead0(ChannelHandlerContext c, Object msg) throws Exception {
        block9: {
            WebSocketFrame frame;
            Channel ch;
            block11: {
                block10: {
                    block8: {
                        ch = this.ctx.channel();
                        if (this.response == null) {
                            this.response = msg instanceof FullHttpResponse ? (FullHttpResponse)msg : new WSResponse((DefaultHttpResponse)msg, this.ctx.alloc().buffer());
                            if (this.completeHandshake(this.ctx)) {
                                return;
                            }
                        }
                        if (msg instanceof LastHttpContent) {
                            return;
                        }
                        if (!(msg instanceof WebSocketFrame)) {
                            throw new Exception("Unexpected FullHttpResponse (getStatus=" + this.response.getStatus() + ", " + "content=" + this.response.content().toString(CharsetUtil.UTF_8) + ')');
                        }
                        frame = (WebSocketFrame)msg;
                        if (!(frame instanceof TextWebSocketFrame)) break block8;
                        for (WebSocketEventListener l : this.listensers) {
                            l.onMessage(c, new WebSocketMessage(((TextWebSocketFrame)frame).text()));
                        }
                        break block9;
                    }
                    if (!(frame instanceof PingWebSocketFrame)) break block10;
                    if (this.autoPong) {
                        this.ctx.writeAndFlush(new PongWebSocketFrame(frame.content().copy()));
                    }
                    for (WebSocketEventListener l : this.listensers) {
                        l.onPing(c, (PingWebSocketFrame)frame.copy());
                    }
                    break block9;
                }
                if (!(frame instanceof PongWebSocketFrame)) break block11;
                LoggerFactory.getLogger(this.getClass()).warn(String.format("WebSocketClient received a PongWebSocketFrame, that shouldn't happen! Data : %s", frame.content().toString(CharsetUtil.UTF_8)));
                break block9;
            }
            if (!(frame instanceof CloseWebSocketFrame)) break block9;
            ch.close();
            for (WebSocketEventListener l : this.listensers) {
                l.onClose(c, (CloseWebSocketFrame)frame.copy());
            }
        }
    }

    protected boolean completeHandshake(ChannelHandlerContext ctx) {
        if (!this.handshaker.isHandshakeComplete()) {
            if (this.response != null && this.response.getStatus().code() > 299) {
                for (WebSocketEventListener l : this.listensers) {
                    l.onError(ctx, null, this.response);
                }
                return true;
            }
            this.handshaker.finishHandshake(ctx.channel(), this.response);
            this.handshakeFuture.setSuccess();
            for (WebSocketEventListener l : this.listensers) {
                l.onConnect(ctx);
            }
            return true;
        }
        return false;
    }

    private static class WSResponse
    extends DefaultFullHttpResponse
    implements FullHttpResponse {
        protected final DefaultHttpResponse response;

        public WSResponse(DefaultHttpResponse msg, ByteBuf content) {
            super(msg.getProtocolVersion(), msg.getStatus(), content);
            this.response = msg;
        }

        @Override
        public HttpHeaders headers() {
            return this.response.headers();
        }

        @Override
        public HttpResponseStatus getStatus() {
            return this.response.getStatus();
        }

        @Override
        public DecoderResult getDecoderResult() {
            return this.response.getDecoderResult();
        }
    }
}

