/*
 * Decompiled with CFR 0.152.
 */
package com.devcycle.sdk.server.common.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SSEMessage {
    private String etag;
    private double lastModified;
    private String type;

    public static SSEMessageBuilder builder() {
        return new SSEMessageBuilder();
    }

    public String getEtag() {
        return this.etag;
    }

    public double getLastModified() {
        return this.lastModified;
    }

    public String getType() {
        return this.type;
    }

    public void setEtag(String etag) {
        this.etag = etag;
    }

    public void setLastModified(double lastModified) {
        this.lastModified = lastModified;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SSEMessage)) {
            return false;
        }
        SSEMessage other = (SSEMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getLastModified(), other.getLastModified()) != 0) {
            return false;
        }
        String this$etag = this.getEtag();
        String other$etag = other.getEtag();
        if (this$etag == null ? other$etag != null : !this$etag.equals(other$etag)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SSEMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $lastModified = Double.doubleToLongBits(this.getLastModified());
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        String $etag = this.getEtag();
        result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "SSEMessage(etag=" + this.getEtag() + ", lastModified=" + this.getLastModified() + ", type=" + this.getType() + ")";
    }

    public SSEMessage(String etag, double lastModified, String type) {
        this.etag = etag;
        this.lastModified = lastModified;
        this.type = type;
    }

    public SSEMessage() {
    }

    public static class SSEMessageBuilder {
        private String etag;
        private double lastModified;
        private String type;

        SSEMessageBuilder() {
        }

        public SSEMessageBuilder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public SSEMessageBuilder lastModified(double lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public SSEMessageBuilder type(String type) {
            this.type = type;
            return this;
        }

        public SSEMessage build() {
            return new SSEMessage(this.etag, this.lastModified, this.type);
        }

        public String toString() {
            return "SSEMessage.SSEMessageBuilder(etag=" + this.etag + ", lastModified=" + this.lastModified + ", type=" + this.type + ")";
        }
    }
}

