/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.basic.common.api.config;

import com.devonfw.module.basic.common.api.config.ConfigProperties;
import com.devonfw.module.basic.common.api.config.ConfigValueUtil;
import com.devonfw.module.basic.common.api.config.MutableConfigProperties;
import com.devonfw.module.basic.common.api.config.MutableConfigPropertiesImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class SimpleConfigProperties
implements ConfigProperties {
    private final String nodeKey;
    private final Map<String, SimpleConfigProperties> childMap;
    private final Set<String> childKeys;
    private String value;
    private int nodeModifications;

    protected SimpleConfigProperties(String key) {
        this.nodeKey = key;
        this.childMap = new HashMap<String, SimpleConfigProperties>();
        this.childKeys = Collections.unmodifiableSet(this.childMap.keySet());
        this.nodeModifications = 0;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    protected String getNodeKey() {
        return this.nodeKey;
    }

    protected int getNodeModifications() {
        return this.nodeModifications;
    }

    @Override
    public Set<String> getChildKeys() {
        this.updateChildren();
        return this.childKeys;
    }

    protected void updateChildren() {
    }

    @Override
    public ConfigProperties getChild(String key) {
        return this.getChild(key, false);
    }

    protected ConfigProperties getChild(String key, boolean create) {
        if (key == null || key.isEmpty()) {
            return this;
        }
        if (key.indexOf(46) > 0) {
            String[] segments = key.split("\\.");
            return this.getChild(create, segments);
        }
        SimpleConfigProperties result = this.childMap.get(key);
        if (result == null) {
            result = this.createChild(key, create);
            if (result == null) {
                return EMPTY;
            }
            this.childMap.put(key, result);
            ++this.nodeModifications;
        }
        return result;
    }

    protected SimpleConfigProperties createChild(String childKey, boolean create) {
        if (!create) {
            return null;
        }
        return new SimpleConfigProperties(SimpleConfigProperties.composeKey(this.nodeKey, childKey));
    }

    @Override
    public ConfigProperties getChild(String ... keys) {
        return this.getChild(false, keys);
    }

    protected ConfigProperties getChild(boolean create, String ... keys) {
        if (keys == null || keys.length == 0) {
            return this;
        }
        SimpleConfigProperties result = this;
        for (String key : keys) {
            ConfigProperties child = result.getChild(key, create);
            if (child.isEmpty()) {
                return child;
            }
            result = (SimpleConfigProperties)child;
        }
        return result;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public <T> T getValue(Class<T> type) {
        return this.getValue(type, null);
    }

    @Override
    public <T> T getValue(Class<T> type, T defaultValue) {
        String result = this.getValue();
        if (result == null) {
            return defaultValue;
        }
        return ConfigValueUtil.convertValue(result, type);
    }

    @Override
    public boolean getValueAsBoolean() {
        return "true".equalsIgnoreCase(this.getValue());
    }

    protected void setValue(String value) {
        this.value = value;
    }

    @Override
    public String getChildValue(String key) {
        return this.getChild(key).getValue();
    }

    @Override
    public String getChildValue(String ... keys) {
        return this.getChild(keys).getValue();
    }

    @Override
    public Map<String, String> toFlatMap() {
        return this.toFlatMap("");
    }

    @Override
    public Map<String, String> toFlatMap(String rootKey) {
        HashMap<String, String> map = new HashMap<String, String>();
        this.toFlatMap(rootKey, map);
        return map;
    }

    private void toFlatMap(String key, Map<String, String> map) {
        this.updateChildren();
        String nodeValue = this.getValue();
        if (nodeValue != null) {
            map.put(key, nodeValue);
        }
        for (Map.Entry<String, SimpleConfigProperties> entry : this.childMap.entrySet()) {
            String childKey = entry.getKey();
            String subKey = SimpleConfigProperties.composeKey(key, childKey);
            entry.getValue().toFlatMap(subKey, map);
        }
    }

    @Override
    public Map<String, Object> toHierarchicalMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.toHierarchicalMap(map);
        return map;
    }

    private void toHierarchicalMap(Map<String, Object> map) {
        String nodeValue = this.getValue();
        if (nodeValue != null) {
            map.put("", nodeValue);
        }
        this.updateChildren();
        for (Map.Entry<String, SimpleConfigProperties> entry : this.childMap.entrySet()) {
            String childKey = entry.getKey();
            HashMap<String, Object> subMap = new HashMap<String, Object>();
            entry.getValue().toHierarchicalMap(subMap);
            map.put(childKey, subMap);
        }
    }

    protected void fromFlatMap(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            SimpleConfigProperties child = (SimpleConfigProperties)this.getChild(entry.getKey(), true);
            child.value = entry.getValue();
        }
    }

    protected void fromHierarchicalMap(Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            SimpleConfigProperties child = (SimpleConfigProperties)this.getChild(entry.getKey(), true);
            Object childObject = entry.getValue();
            if (childObject instanceof Map) {
                child.fromHierarchicalMap((Map)childObject);
                continue;
            }
            child.value = childObject.toString();
        }
    }

    public String toString() {
        if (this.nodeKey == null || this.nodeKey.isEmpty()) {
            return "<empty>";
        }
        StringBuilder buffer = new StringBuilder(this.nodeKey);
        buffer.append('=');
        String nodeValue = this.getValue();
        if (nodeValue != null) {
            buffer.append(nodeValue);
        }
        return buffer.toString();
    }

    @Override
    public MutableConfigProperties inherit(ConfigProperties parentNode) {
        return new MutableConfigPropertiesImpl(this.getNodeKey(), this, parentNode);
    }

    public static ConfigProperties ofFlatMap(Map<String, String> map) {
        return SimpleConfigProperties.ofFlatMap("", map);
    }

    public static ConfigProperties ofFlatMap(String key, Map<String, String> map) {
        SimpleConfigProperties root = new SimpleConfigProperties(key);
        root.fromFlatMap(map);
        return root;
    }

    public static ConfigProperties ofHierarchicalMap(Map<String, Object> map) {
        return SimpleConfigProperties.ofHierarchicalMap("", map);
    }

    public static ConfigProperties ofHierarchicalMap(String key, Map<String, Object> map) {
        SimpleConfigProperties root = new SimpleConfigProperties(key);
        root.fromHierarchicalMap(map);
        return root;
    }

    protected static String composeKey(String parentKey, String childKey) {
        if (parentKey.isEmpty()) {
            return childKey;
        }
        return parentKey + '.' + childKey;
    }

    protected static SimpleConfigProperties asSimple(ConfigProperties configProperties) {
        if (configProperties instanceof SimpleConfigProperties) {
            return (SimpleConfigProperties)configProperties;
        }
        return null;
    }
}

