/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.batch.common.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.configuration.JobLocator;
import org.springframework.batch.core.converter.DefaultJobParametersConverter;
import org.springframework.batch.core.converter.JobParametersConverter;
import org.springframework.batch.core.launch.JobExecutionNotRunningException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.launch.JobOperator;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.StringUtils;

public class SpringBootBatchCommandLine {
    private static final Logger LOG = LoggerFactory.getLogger(SpringBootBatchCommandLine.class);
    private JobLauncher launcher;
    private JobLocator locator;
    private JobParametersConverter parametersConverter;
    private JobOperator operator;

    public static void main(String[] args) throws Exception {
        if (args.length < 3) {
            SpringBootBatchCommandLine.handleIncorrectParameters();
            return;
        }
        ArrayList<String> configurations = new ArrayList<String>(2);
        configurations.add(args[0]);
        configurations.add(args[1]);
        ArrayList<String> parameters = new ArrayList<String>();
        Operation op = Operation.START;
        if (args.length > 3 && args[3].equalsIgnoreCase("-stop")) {
            if (args.length > 4) {
                SpringBootBatchCommandLine.handleIncorrectParameters();
                return;
            }
            op = Operation.STOP;
        } else {
            for (int i = 3; i < args.length; ++i) {
                parameters.add(args[i]);
            }
        }
        new SpringBootBatchCommandLine().execute(op, configurations, args[2], parameters);
    }

    private static void handleIncorrectParameters() {
        LOG.error("Incorrect parameters.");
        LOG.info("Usage:");
        LOG.info("java com.devonfw.module.batch.common.base.SpringBootBatchCommandLine <SpringBootConfiguration> <BatchJobConfiguration> <JobName> param1=value1 param2=value2 ...");
        LOG.info("For stopping all running executions of a batch job:");
        LOG.info("java com.devonfw.module.batch.common.base.BatchCommandLine <SpringBootConfiguration> <BatchJobConfiguration> <JobName> -stop");
        LOG.info("Example:");
        LOG.info("java com.devonfw.module.batch.common.base.SpringBootBatchCommandLine com.devonfw.gastronomy.restaurant.SpringBootBatchApp classpath:config/app/batch/beans-productimport.xml productImportJob drinks.file=file:import/drinks.csv date(date)=2015/12/20");
    }

    protected int getReturnCode(JobExecution jobExecution) {
        if (jobExecution.getStatus() != null && jobExecution.getStatus() == BatchStatus.COMPLETED) {
            return 0;
        }
        return 1;
    }

    private void findBeans(ConfigurableApplicationContext ctx) {
        this.launcher = (JobLauncher)ctx.getBean(JobLauncher.class);
        this.locator = (JobLocator)ctx.getBean(JobLocator.class);
        this.operator = (JobOperator)ctx.getBean(JobOperator.class);
        try {
            this.parametersConverter = (JobParametersConverter)ctx.getBean(JobParametersConverter.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            this.parametersConverter = new DefaultJobParametersConverter();
        }
    }

    public void execute(Operation operation, List<String> configurations, String jobName, List<String> parameters) throws Exception {
        Class[] configurationClasses = new Class[configurations.size()];
        for (int i = 0; i < configurations.size(); ++i) {
            configurationClasses[i] = Class.forName(configurations.get(i));
        }
        SpringApplication app = new SpringApplication(configurationClasses);
        app.setWebEnvironment(false);
        ConfigurableApplicationContext ctx = app.run(new String[0]);
        switch (operation) {
            case START: {
                this.startBatch(ctx, jobName, parameters);
                break;
            }
            case STOP: {
                this.stopBatch(ctx, jobName);
                break;
            }
            default: {
                throw new RuntimeException("Unknown operation: " + (Object)((Object)operation));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startBatch(ConfigurableApplicationContext ctx, String jobName, List<String> parameters) throws Exception {
        int returnCode;
        JobExecution jobExecution = null;
        try {
            this.findBeans(ctx);
            JobParameters params = this.parametersConverter.getJobParameters(StringUtils.splitArrayElementsIntoProperties((String[])parameters.toArray(new String[0]), (String)"="));
            jobExecution = this.launcher.run(this.locator.getJob(jobName), params);
            int n = returnCode = jobExecution == null ? 1 : this.getReturnCode(jobExecution);
        }
        catch (Throwable throwable) {
            int returnCode2;
            int n = returnCode2 = jobExecution == null ? 1 : this.getReturnCode(jobExecution);
            if (jobExecution == null) {
                LOG.error("Batch Status: Batch could not be started.");
            } else {
                LOG.info("Batch start time: {}", jobExecution.getStartTime() == null ? "null" : jobExecution.getStartTime());
                LOG.info("Batch end time: {}", jobExecution.getEndTime() == null ? "null" : jobExecution.getEndTime());
                if (returnCode2 == 0) {
                    LOG.info("Batch Status: {}", (Object)(jobExecution.getStatus() == null ? "null" : jobExecution.getStatus()));
                } else {
                    LOG.error("Batch Status: {}", (Object)(jobExecution.getStatus() == null ? "null" : jobExecution.getStatus()));
                }
            }
            LOG.info("Return Code: {}", (Object)returnCode2);
            SpringApplication.exit((ApplicationContext)ctx, (ExitCodeGenerator[])new ExitCodeGenerator[]{new ExitCodeGenerator(returnCode2){
                final /* synthetic */ int val$returnCode;
                {
                    this.val$returnCode = n;
                }

                public int getExitCode() {
                    return this.val$returnCode;
                }
            }});
            throw throwable;
        }
        if (jobExecution == null) {
            LOG.error("Batch Status: Batch could not be started.");
        } else {
            LOG.info("Batch start time: {}", jobExecution.getStartTime() == null ? "null" : jobExecution.getStartTime());
            LOG.info("Batch end time: {}", jobExecution.getEndTime() == null ? "null" : jobExecution.getEndTime());
            if (returnCode == 0) {
                LOG.info("Batch Status: {}", (Object)(jobExecution.getStatus() == null ? "null" : jobExecution.getStatus()));
            } else {
                LOG.error("Batch Status: {}", (Object)(jobExecution.getStatus() == null ? "null" : jobExecution.getStatus()));
            }
        }
        LOG.info("Return Code: {}", (Object)returnCode);
        SpringApplication.exit((ApplicationContext)ctx, (ExitCodeGenerator[])new ExitCodeGenerator[]{new /* invalid duplicate definition of identical inner class */});
    }

    private void stopBatch(ConfigurableApplicationContext ctx, String jobName) throws Exception {
        int returnCodeResult;
        int returnCode = 0;
        try {
            this.findBeans(ctx);
            Set runningJobExecutionIDs = this.operator.getRunningExecutions(jobName);
            if (runningJobExecutionIDs.isEmpty()) {
                throw new JobExecutionNotRunningException("Batch job " + jobName + " is currently not being executed.");
            }
            LOG.debug("Found {} executions to be stopped (potentially already in state stopping).", (Object)runningJobExecutionIDs.size());
            int stoppedCount = 0;
            for (Long id : runningJobExecutionIDs) {
                try {
                    this.operator.stop(id.longValue());
                    ++stoppedCount;
                }
                catch (JobExecutionNotRunningException jobExecutionNotRunningException) {}
            }
            LOG.info("Actually stopped {} batch executions.", (Object)stoppedCount);
            returnCodeResult = returnCode;
        }
        catch (Exception e) {
            try {
                returnCode = 1;
                throw e;
            }
            catch (Throwable throwable) {
                int returnCodeResult2 = returnCode;
                SpringApplication.exit((ApplicationContext)ctx, (ExitCodeGenerator[])new ExitCodeGenerator[]{new ExitCodeGenerator(returnCodeResult2){
                    final /* synthetic */ int val$returnCodeResult;
                    {
                        this.val$returnCodeResult = n;
                    }

                    public int getExitCode() {
                        return this.val$returnCodeResult;
                    }
                }});
                throw throwable;
            }
        }
        SpringApplication.exit((ApplicationContext)ctx, (ExitCodeGenerator[])new ExitCodeGenerator[]{new /* invalid duplicate definition of identical inner class */});
    }

    public static enum Operation {
        START,
        STOP;

    }
}

