/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.batch.common.impl;

import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;

public class JobLauncherWithAdditionalRestartCapabilities
extends SimpleJobLauncher {
    private JobRepository jobRepository;

    public JobExecution run(Job job, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException, JobParametersInvalidException {
        if (!job.isRestartable()) {
            JobParameters originalParameters = jobParameters;
            while (this.jobRepository.isJobInstanceExists(job.getName(), jobParameters)) {
                JobExecution jobExecution = this.jobRepository.getLastJobExecution(job.getName(), jobParameters);
                if (jobExecution.isRunning()) {
                    throw new JobExecutionAlreadyRunningException("A job execution for this job is already running: " + jobExecution.getJobInstance());
                }
                BatchStatus status = jobExecution.getStatus();
                if (status == BatchStatus.COMPLETED || status == BatchStatus.ABANDONED) {
                    throw new JobInstanceAlreadyCompleteException("A job instance already exists and is complete for parameters=" + originalParameters + ".  If you want to run this job again, change the parameters.");
                }
                jobParameters = job.getJobParametersIncrementer().getNext(jobParameters);
            }
        }
        return super.run(job, jobParameters);
    }

    public void setJobRepository(JobRepository jobRepository) {
        super.setJobRepository(jobRepository);
        this.jobRepository = jobRepository;
    }
}

