/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.batch.common.impl;

import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ItemProcessListener;
import org.springframework.batch.core.ItemReadListener;
import org.springframework.batch.core.ItemWriteListener;
import org.springframework.batch.core.SkipListener;

public class ChunkLoggingListener<T, S>
implements SkipListener<T, S>,
ItemReadListener<T>,
ItemProcessListener<T, S>,
ItemWriteListener<S> {
    private static final Logger LOG = LoggerFactory.getLogger(ChunkLoggingListener.class);

    protected String itemToString(Object item) {
        return item.toString();
    }

    public void onReadError(Exception e) {
        LOG.error("Failed to read item.", (Throwable)e);
    }

    public void onProcessError(T item, Exception e) {
        LOG.error("Failed to process item: " + this.itemToString(item), (Throwable)e);
    }

    public void onWriteError(Exception e, List<? extends S> items) {
        LOG.error("Failed to write items: " + this.itemToString(items), (Throwable)e);
    }

    public void onSkipInRead(Throwable t) {
        LOG.warn("Skipped item in read.", t);
    }

    public void onSkipInProcess(T item, Throwable t) {
        LOG.warn("Skipped item in process: " + this.itemToString(item), t);
    }

    public void onSkipInWrite(S item, Throwable t) {
        LOG.warn("Skipped item in write: " + this.itemToString(item), t);
    }

    public void beforeRead() {
    }

    public void afterRead(T item) {
    }

    public void beforeProcess(T item) {
    }

    public void afterProcess(T item, S result) {
    }

    public void beforeWrite(List<? extends S> items) {
    }

    public void afterWrite(List<? extends S> items) {
    }
}

