/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.jpa.dataaccess.api;

import com.devonfw.module.basic.common.api.query.LikePatternSyntax;
import com.devonfw.module.basic.common.api.query.StringSearchConfigTo;
import com.devonfw.module.basic.common.api.query.StringSearchOperator;
import com.devonfw.module.jpa.dataaccess.api.DatabaseConfigProperties;
import com.querydsl.core.JoinExpression;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.ComparablePath;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.SimpleExpression;
import com.querydsl.core.types.dsl.StringExpression;
import com.querydsl.jpa.impl.JPAQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.StringUtils;

public class QueryHelper {
    private static final Logger LOG = LoggerFactory.getLogger(QueryHelper.class);
    protected static final String QUERY_PROPERTY_TIMEOUT = "javax.persistence.query.timeout";

    protected void applyTimeout(JPAQuery<?> query, Number timeout) {
        if (timeout != null) {
            query.setHint(QUERY_PROPERTY_TIMEOUT, (Object)timeout.intValue());
        }
    }

    protected void whereLike(JPAQuery<?> query, StringExpression expression, String pattern, LikePatternSyntax syntax, boolean ignoreCase, boolean matchSubstring) {
        BooleanExpression like = this.newLikeClause(expression, pattern, syntax, ignoreCase, matchSubstring, false);
        if (like != null) {
            query.where((Predicate)like);
        }
    }

    protected void whereNotLike(JPAQuery<?> query, StringExpression expression, String pattern, LikePatternSyntax syntax, boolean ignoreCase, boolean matchSubstring) {
        BooleanExpression like = this.newLikeClause(expression, pattern, syntax, ignoreCase, matchSubstring, true);
        if (like != null) {
            query.where((Predicate)like);
        }
    }

    protected BooleanExpression newLikeClause(StringExpression expression, String pattern, LikePatternSyntax syntax, boolean ignoreCase, boolean matchSubstring) {
        return this.newLikeClause(expression, pattern, syntax, ignoreCase, matchSubstring, false);
    }

    protected BooleanExpression newNotLikeClause(StringExpression expression, String pattern, LikePatternSyntax syntax, boolean ignoreCase, boolean matchSubstring) {
        return this.newLikeClause(expression, pattern, syntax, ignoreCase, matchSubstring, true);
    }

    protected BooleanExpression newLikeClause(StringExpression expression, String pattern, LikePatternSyntax syntax, boolean ignoreCase, boolean matchSubstring, boolean negate) {
        if (syntax == null && (syntax = LikePatternSyntax.autoDetect((String)pattern)) == null) {
            syntax = LikePatternSyntax.SQL;
        }
        String likePattern = LikePatternSyntax.SQL.convert(pattern, syntax, matchSubstring);
        StringExpression exp = expression;
        if (ignoreCase) {
            likePattern = likePattern.toUpperCase(Locale.US);
            exp = exp.upper();
        }
        BooleanExpression clause = syntax != LikePatternSyntax.SQL ? exp.like(likePattern, '\\') : exp.like(likePattern);
        if (negate) {
            clause = clause.not();
        }
        return clause;
    }

    protected BooleanExpression newStringClause(StringExpression expression, String value, StringSearchConfigTo config) {
        StringSearchOperator operator = StringSearchOperator.EQ;
        LikePatternSyntax syntax = null;
        boolean ignoreCase = false;
        boolean matchSubstring = false;
        if (config != null) {
            operator = config.getOperator();
            syntax = config.getLikeSyntax();
            ignoreCase = config.isIgnoreCase();
            matchSubstring = config.isMatchSubstring();
        }
        return this.newStringClause(expression, value, operator, syntax, ignoreCase, matchSubstring);
    }

    protected BooleanExpression newStringClause(StringExpression expression, String value, StringSearchOperator operator, LikePatternSyntax syntax, boolean ignoreCase, boolean matchSubstring) {
        String v;
        if (operator == null) {
            operator = syntax == null ? ((syntax = LikePatternSyntax.autoDetect((String)value)) == null ? StringSearchOperator.EQ : StringSearchOperator.LIKE) : StringSearchOperator.LIKE;
        }
        if (matchSubstring && (operator == StringSearchOperator.EQ || operator == StringSearchOperator.NE)) {
            if (syntax == null) {
                syntax = LikePatternSyntax.SQL;
            }
            operator = operator == StringSearchOperator.EQ ? StringSearchOperator.LIKE : StringSearchOperator.NOT_LIKE;
        }
        if ((v = value) == null) {
            switch (operator) {
                case LIKE: 
                case EQ: {
                    return expression.isNull();
                }
                case NE: {
                    return expression.isNotNull();
                }
            }
            throw new IllegalArgumentException("Operator " + operator + " does not accept null!");
        }
        if (v.isEmpty()) {
            switch (operator) {
                case LIKE: 
                case EQ: {
                    return expression.isEmpty();
                }
                case NE: 
                case NOT_LIKE: {
                    return expression.isNotEmpty();
                }
            }
        }
        StringExpression exp = expression;
        if (ignoreCase) {
            v = v.toUpperCase(Locale.US);
            exp = exp.upper();
        }
        switch (operator) {
            case LIKE: {
                return this.newLikeClause(exp, v, syntax, false, matchSubstring, false);
            }
            case NOT_LIKE: {
                return this.newLikeClause(exp, v, syntax, false, matchSubstring, true);
            }
            case EQ: {
                return exp.eq((Object)v);
            }
            case NE: {
                return exp.ne((Object)v);
            }
            case LT: {
                return exp.lt((Comparable)((Object)v));
            }
            case LE: {
                return exp.loe((Comparable)((Object)v));
            }
            case GT: {
                return exp.gt((Comparable)((Object)v));
            }
            case GE: {
                return exp.goe((Comparable)((Object)v));
            }
        }
        throw new IllegalStateException("" + operator);
    }

    protected void whereString(JPAQuery<?> query, StringExpression expression, String value, StringSearchConfigTo config) {
        BooleanExpression clause = this.newStringClause(expression, value, config);
        if (clause != null) {
            query.where((Predicate)clause);
        }
    }

    protected <T> BooleanExpression newInClause(SimpleExpression<T> expression, Collection<T> inValues) {
        if (inValues == null || inValues.isEmpty()) {
            return null;
        }
        int size = inValues.size();
        if (size == 1) {
            return expression.eq(inValues.iterator().next());
        }
        int maxSizeOfInClause = DatabaseConfigProperties.getInstance().getMaxSizeOfInClause();
        if (size <= maxSizeOfInClause) {
            return expression.in(inValues);
        }
        LOG.warn("Creating workaround for IN-clause with {} items - this can cause performance problems.", (Object)size);
        ArrayList<T> values = inValues instanceof List ? (ArrayList<T>)inValues : new ArrayList<T>(inValues);
        BooleanExpression predicate = null;
        int start = 0;
        while (start < size) {
            int end = start + maxSizeOfInClause;
            if (end > size) {
                end = size;
            }
            List partition = values.subList(start, end);
            predicate = predicate == null ? expression.in(partition) : predicate.or((Predicate)expression.in(partition));
            start = end;
        }
        return predicate;
    }

    protected <T> void whereIn(JPAQuery<?> query, SimpleExpression<T> expression, Collection<T> inValues) {
        BooleanExpression inClause = this.newInClause(expression, inValues);
        if (inClause != null) {
            query.where((Predicate)inClause);
        }
    }

    protected <E> Page<E> findPaginatedGeneric(Pageable pageable, JPAQuery<E> query, boolean determineTotal) {
        long total = -1L;
        if (determineTotal) {
            total = ((JPAQuery)query.clone()).fetchCount();
        }
        long offset = 0L;
        if (pageable != null) {
            offset = pageable.getOffset();
            query.offset(offset);
            query.limit((long)pageable.getPageSize());
            this.applySort(query, pageable.getSort());
        }
        List hits = query.fetch();
        if (total == -1L) {
            total = offset + (long)hits.size();
        }
        return new PageImpl(hits, pageable, total);
    }

    protected void applySort(JPAQuery<?> query, Sort sort) {
        if (sort == null) {
            return;
        }
        PathBuilder<?> alias = this.findAlias(query);
        for (Sort.Order order : sort) {
            String property = order.getProperty();
            Sort.Direction direction = order.getDirection();
            ComparablePath path = alias.getComparable(property, Comparable.class);
            OrderSpecifier orderSpecifier = direction == Sort.Direction.ASC ? path.asc() : path.desc();
            query.orderBy(orderSpecifier);
        }
    }

    private <E> PathBuilder<E> findAlias(JPAQuery<E> query) {
        JoinExpression join;
        Expression target;
        String alias = null;
        List joins = query.getMetadata().getJoins();
        if (joins != null && !joins.isEmpty() && (target = (join = (JoinExpression)joins.get(0)).getTarget()) instanceof EntityPath) {
            alias = target.toString();
        }
        Class type = query.getType();
        if (alias == null) {
            alias = StringUtils.uncapitalize((String)type.getSimpleName());
        }
        return new PathBuilder(type, alias);
    }
}

