/*
 * Decompiled with CFR 0.152.
 */
package com.devonfw.module.jpa.dataaccess.api;

import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

class DatabaseConfigProperties {
    private static final Logger LOG = LoggerFactory.getLogger(DatabaseConfigProperties.class);
    private static DatabaseConfigProperties instance;
    @Value(value="${database.query.in-clause.max-values:2147483647}")
    private int maxSizeOfInClause = Integer.MAX_VALUE;
    public static final int MAX_SIZE_OF_IN_CLAUSE_IN_ORACLE = 1000;

    @PostConstruct
    protected void initialize() {
        if (instance == null) {
            instance = this;
            LOG.debug("Registering DB configuration instance {}.", (Object)this);
        } else {
            LOG.warn("Instance {} has already been registered and can not be replaced by {}", (Object)instance, (Object)this);
        }
    }

    public int getMaxSizeOfInClause() {
        return this.maxSizeOfInClause;
    }

    public static DatabaseConfigProperties getInstance() {
        if (instance == null) {
            new DatabaseConfigProperties();
        }
        return instance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[maxSizeOfInClause=" + this.maxSizeOfInClause + "]";
    }
}

